package Freenet.message;
import java.io.*;
import java.net.*;
import Freenet.*;
import Freenet.node.*;
import Freenet.support.*;
import Freenet.support.io.DataNotValidIOException;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: Node (1.0)
                    Address (1.0)
		    Message (1.0)
 */

/**
 * This is the DataReply message
 *
 * @see Node
 * @see Address
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 * @author oskar (rewritten from scratch... several times)
 **/

public class DataReply extends DataSend
{

    public static final String messageName = "DataReply";

    public DataReply(long idnum, long htl, long depth, 
		     FieldSet fs) throws UnknownHostException {
	
	super(idnum, htl, depth, fs);
    }

    public DataReply(long idnum, long htl, long depth, Entity doc)
	throws IOException, BadDataException, BadAddressException {
	
	super(idnum, htl, depth, doc);
    }
    
    public DataReply(RawMessage raw)
	throws InvalidMessageException, BadAddressException {
	
	super(raw);	
    }

    public RawMessage toRawMessage(Presentation t) {
	RawMessage raw=super.toRawMessage(t);
	raw.messageType="DataReply";
	return raw;
    }

    // Protected/Private Methods

    protected MessageMemory timeOut(Node n, MessageMemory sb)
    {
	if (sb == null || sb.depth <= 0) return null;

	TimedOut to=new TimedOut(id, sb.depth);
    
	try {
	    to.sendBack(n,sb);
	} catch(SendFailedException sfe) {
	    Core.logger.log(this,"Send failed on timedout",Logger.NORMAL);
	}

        return super.timeOut(n,sb);
    }

    protected SendDone getSendDone(InputStream in) {
	return new ReplySendDone(in);
    }

    // callback for sent finished
    private class ReplySendDone extends SendDone {
	
	public ReplySendDone(InputStream in) {
	    super(DataReply.this.id, in);
	}
	
  
	protected MessageMemory sendFinished(Node n, KeyedMM kmm) {
	    // sendback the storedata message.
	    try {
		if (!n.getTransience() && 
		    (kmm.storeData.dataSource == null 
		     || receivedAt == null 
		     || (n.randSource.nextInt() % 30) == 0)) {
		    kmm.storeData.resetDataSource(true);
		}
		ConnectionHandler ch;
		if (kmm.replyCon == null || !kmm.replyCon.isOpen()) {
		    ch = n.makeConnection(kmm.origRec);
		} else {
		    ch = kmm.replyCon;
		}
		kmm.storeData.sending(n, ch);
		ch.unlockedSend(kmm.storeData,null);
	    } catch (ConnectFailedException cfe) {
		Core.logger.log(this,"Send of StoreData message to " + 
				cfe.peer + 
				" following finished trailing field failed",
				Logger.MINOR);
	    } catch (SendFailedException sfe) {
		Core.logger.log(this,"Send of StoreData message to " + 
				sfe.peer + 
				" following finished trailing field failed",
				Logger.MINOR);
	    }
	    kmm.state = kmm.DONE;
	    return kmm;
	}

	protected MessageMemory sendFailed(Node n, KeyedMM kmm, 
					   ConduitException ce) {
	    kmm.state = kmm.PENDING;
	    
	    if (ce.inRead()) {
		if (ce.getIOException() 
		    instanceof DataNotValidIOException) {
		    
		    int cb = ((DataNotValidIOException) ce
			      .getIOException()).getCode();

		    kmm.data = null;
		    
		    try {
			if (cb == Presentation.CB_BAD_DATA || 
			    cb == Presentation.CB_CONN_DIED) {
				// restart chain here
			    ce.getOutStream().write(Presentation.CB_RESTARTED);
			    if (kmm.rr != null)
				n.timer.add(0, kmm.rr); // start now!
			} else if (cb == Presentation.CB_RESTARTED) {
			    ce.getOutStream().write(Presentation.CB_RESTARTED);

				// put the rcb back with some time for the next nodes
				// QueryRestarted to be handled
			    if (kmm.rr != null)
				n.timer.add(RequestRestarted.getTime(1),
					    kmm.rr);
			    if (kmm.queryRestarted != null)
				// QueryRestarted message was handled first 
				// but postponed 
				// itself (note we call pReceived for htl 
				// and depth) 
				kmm = (KeyedMM) kmm.queryRestarted.pReceived(n,kmm);
			} else {
			    Core.logger.log(this,
					    "Choked on unknown Control byte: "
					    + cb,
					    Logger.NORMAL);
			}
		    } catch (IOException ioe) {
			Core.logger.log(this,
					"Error writing control byte",
					Logger.MINOR);
		    }
		} else {
		    Core.logger.log(this,
				    "Error reading from local cache!",
				    Logger.ERROR);
		} 
	    } else {
		Core.logger.log(this,
			   "Ouput error sending trailing field",
			   Logger.MINOR);
	    }
	    return kmm;
	}
    }
}








