package Freenet.message;
//import java.net.*;
import Freenet.*;
import Freenet.node.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This implements a simple echo message which will pass through several
 * nodes, and then pass back through them again.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class Echo extends Message
{

    public static final String messageName = "Echo";

  public Address[] visits;

  /**
   * Creates a new echo message which will pass through all nodes 
   * specified in v, and then back again - eventually returning
   * to the user.
   * @param v List of addresses the message should be passed through
   **/

  public Echo(long idnum, long htl, Address[] v)
    {
      super(idnum, htl, (long)0, null);
      visits = v;
    }

  public Echo(RawMessage r)
      throws InvalidMessageException, BadAddressException
    {
      super(r);
      String no_vis;
      no_vis = otherFields.get("Hops");
      if (no_vis == null)
	throw new InvalidMessageException
	  ("Echo: No Hops field");
      visits = new Address[(new Integer(no_vis)).intValue()];
      for (int x=0; x<visits.length; x++)
	{
	  String rd = otherFields.get("hop"+x);
	  if (rd == null)
	    throw new InvalidMessageException
	      ("Echo: No hop"+x+" field");
	  visits[x] = new Address(rd);
	}
    }

  // Public Methods

  public RawMessage toRawMessage(Presentation t)
    {
      RawMessage r = super.toRawMessage(t);
      r.messageType = "Echo";
      r.fs.add("Hops", String.valueOf(visits.length));
      for (int x=0; x<visits.length; x++)
	{
	  r.fs.add("hop"+x, visits[x].toString());
	}
      return r;
    }

  public MessageMemory pReceived(Node n, MessageMemory sb)
    {
      if (sb==null)
	{ // This is the first time this message was received by this node
	  if (visits.length == 0)
	    { // No hops left, back to where we came from
		try {
		    n.sendMessage(this, source);
		} catch (SendFailedException sfe) {}		    
	      return null;
	    }
	  Address src = this.source;
	  // Move everything up in queue
	  Address dest = this.visits[0];
	  Address[] tmp = new Address[visits.length-1];
	  for (int x=0; x<tmp.length; x++)
	    {
	      tmp[x] = visits[x+1];
	    }
	  visits = tmp;
	  // And send this message!
	  try {
	      n.sendMessage(this, dest);
	  } catch(SendFailedException sfe) {}
	  // And return the source address to be picked up the next time
	  // this message passes this node
	  return new MessageMemory(src, depth);
	}
      else
	{ // This is not the first time this node has seen this message,
	  // just forward it back to where it originally came from (this
	  // address should be stored in the passed through object sb)
	    try {
		n.sendMessage(this, sb.origRec);
	    } catch(SendFailedException sfe) {}	
	  return null;
	}
    }

}



