package Freenet.message;

import Freenet.*;
import Freenet.node.*;
import java.util.*;
import Freenet.support.Logger;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This is the superclass of all handshakes
 *
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 **/

public class HandshakeReply extends Handshake
{

    public static final String messageName = "HandshakeReply";

  public String version;
    public String build;
    public String revision;

  public HandshakeReply(long idnum)
    {
      super(idnum);
      version=Node.protocolVersion;
      build=Node.buildNumber;
      revision=Node.serverRevision;
    }

  public HandshakeReply(RawMessage raw) throws InvalidMessageException
  {
    super(raw);
    version=otherFields.get("Version");
    otherFields.remove("Version");
    otherFields.remove("Build");
    otherFields.remove("Revision");
  }

  public RawMessage toRawMessage(Presentation t)
    {
      RawMessage r = super.toRawMessage(t);
      r.messageType="HandshakeReply";
      r.fs.add("Version", version);
      if (build != null)
	  r.fs.add("Build", build);
      if (revision != null)
	  r.fs.add("Revision",revision);
      r.trailingFieldName="EndMessage";
      return r;
    }

    public boolean check() {
	return version.equals(Node.protocolVersion);
    }

    public MessageMemory pReceived(Node n, MessageMemory sb) {
	handle(n);
	return null;
    }
 
    public void handle(Core c) {
	if(check()) {
	    Core.logger.log(this,"Setting handshake from " + source,
			    Logger.DEBUGGING);
	    c.hh.setHandshake(id);
	} else {
	    Core.logger.log(this,"Bad handshake received",Logger.MINOR);
	    c.hh.failHandshake(id);
	}
	return;
    }

    protected MessageMemory timeOut(Node n, MessageMemory sb)
    {
	return pReceived(n, sb);
    }
}



