/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This is the HandshakeRequest message
 *
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 **/

package Freenet.message;
import Freenet.*;
import Freenet.node.*;
import java.util.*;
import Freenet.support.*;

public class HandshakeRequest extends Handshake
{

    public static final String messageName = "HandshakeRequest";

    private boolean keepalive;

    public HandshakeRequest(long idnum) {
	super(idnum);
    }


    public HandshakeRequest(RawMessage raw) throws InvalidMessageException {
	super(raw);
    } 

    public MessageMemory pReceived(Node n, MessageMemory sb) {
	handle(n);
	return null;
    }

    public void handle(Core c) {
	Core.logger.log(this,"Received handshake request",Logger.DEBUGGING);
        HandshakeReply shake = new HandshakeReply(id);
	
	try {
	    ConnectionHandler ch;
	    if (receivedWith == null) {
		ch = c.connect(source);
		shake.keepAlive = false;
	    } else if (!receivedWith.isOpen()) {
	    	ch = c.connect(source);
	    } else
		ch = receivedWith;
	    shake.sending(c,ch);
	    ch.sendMessage(shake);

	} catch(SendFailedException e) {
	    Core.logger.log(this,"Could not send handshake reply",Logger.MINOR);
	} catch(ConnectFailedException e) {
	    Core.logger.log(this,"Could not send handshake reply",Logger.MINOR);
	}
  }

  public RawMessage toRawMessage(Presentation t)
    {
      RawMessage r = super.toRawMessage(t);
      r.messageType="HandshakeRequest";
      return r;
    }

    protected MessageMemory timeOut(Node n, MessageMemory sb) {
	return pReceived(n, sb);
    }

}





