package Freenet.message;
import Freenet.*;
import Freenet.node.*;
import Freenet.support.Logger;
import java.io.*;

public class InsertReply extends Message {

    public static final String messageName = "InsertReply";

    public InsertReply(long idnum, long htl) {
	super(idnum, htl, (long)0, null);
    }

    public InsertReply(RawMessage raw) throws InvalidMessageException {
	super(raw);
    }

    public RawMessage toRawMessage(Presentation t) {
	RawMessage raw=super.toRawMessage(t);
	raw.messageType="InsertReply";
	return raw;
    }

    public MessageMemory pReceived(Node n, MessageMemory sb) {
	if(sb==null || !(sb instanceof KeyedMM)) // No one requested this, or I forgot about it
	    return sb;
	else { // Forward it to whoever requested insert.
	    KeyedMM kmm = (KeyedMM) sb;
	    if (kmm.state != kmm.PENDING) {
		Core.logger.log(this,"Received unexpected InsertReply message",
				Logger.MINOR);
		return sb;
	    }

	    if (kmm.rr != null) {
		kmm.rr.cancel();
		kmm.rr = null;
	    }

	    try {
		kmm.replyCon =  sendBack(n, kmm);
	    } catch (SendFailedException sfe) {
		Core.logger.log(this,"Send failed on return to " + sfe.peer,
				Logger.NORMAL);
		kmm.state = kmm.DONE;
		return null;
	    }

	    //data sent should now be sent back up the path of this message
	    kmm.dataref = source;
	    kmm.dataCon = receivedWith;

	    // send back no more messages
	    kmm.origRec = null;
	    kmm.replyCon = null;
	    kmm.state = kmm.AWAITING_DATA;

	    return kmm;
	}
    }
    
    protected MessageMemory timeOut(Node n, MessageMemory sb)
    {

	Core.logger.log(this,"Errant InsertReply message died",Logger.NORMAL);
	return sb;
    }
}



