
package Freenet.message;

import java.io.*;
import Freenet.*;
import Freenet.node.*;
import Freenet.support.*;

public class InsertRequest extends Request {

    public static final String messageName = "InsertRequest";

  public InsertRequest(long idnum, long htl, long depth, Key key)
  {
      super(idnum, htl, depth, key);
  }

  public InsertRequest(RawMessage raw) throws InvalidMessageException
  {
      super(raw);
  }

  public RawMessage toRawMessage(Presentation t)
  {
    RawMessage raw=super.toRawMessage(t);
    raw.messageType="InsertRequest";
    return raw;
  }

    public static KeyedMM failedTimedOut(Node n, long id, KeyedMM kmm) {
	// Cancel existing timeout
	if (kmm.rr != null)
	    kmm.rr.cancel();

	InsertReply ir = new InsertReply(id, kmm.depth);
	try {
	    ir.sendBack(n,kmm);
	} catch(SendFailedException sfe) {
	    Core.logger.log(null,
			    "InsertRequest,Send of InsertReply message failed",
			    Logger.NORMAL);
	}

	kmm.dataref=null; // messages stop here
	kmm.replyCon=null;
	kmm.origRec=null; // keep future message from going back beyond here
	return kmm;
    }

    protected void refFound(NodeReference ref, Node n, 
			    KeyedMM kmm) throws RequestAbortException {
	Core.logger.log(this,"Key collision, received InsertRequest for previously known key, requesting its original data",Logger.MINOR);
	DataRequest dr = new DataRequest(id,hopsToLive,depth,searchKey);
	dr.initSources(receivedAt,source,receivedWith);
	throw new RequestAbortException(dr.pReceived(n,null)); // Handle this as request and return result
    }

    protected void dataFound(Entity doc, Node n, 
			     KeyedMM kmm) throws RequestAbortException {
	// do the same as ref (I could just return the data right here, but since situations like read failing are handled better by the DataRequest code anyways
	refFound(new NodeReference(receivedAt), n,kmm);
    }

    protected MessageMemory timeOut(Node n, MessageMemory mm) {
	KeyedMM kmm;

	if (mm == null || !(mm instanceof KeyedMM)) {
	    kmm = new KeyedMM(source,depth,null,searchKey,null,this.getClass(), null);
	    kmm.state = kmm.AWAITING_DATA;
	} else {
	    kmm = (KeyedMM) mm;
	    // kmm.state = AWAITING_DATA;
	    // if the search looped here then the DataInsert will have set the reference to null already when it gets here the second time and therefore stop, so we don't need to (and shouldn't, so we don't interfere with the first passage) do anything.
	}

	// do we have it?
	try {
	    searchData(n, searchKey,kmm);  // from Request class
	} catch (RequestAbortException rae) {
	    // this means we found it
	    return rae.mm;
	};

	InsertReply ir = new InsertReply(id, depth);
	try {
	    sendReply(n, ir);
	} catch(SendFailedException sfe) {
	    Core.logger.log(this,"Send of InsertReply message failed",Logger.NORMAL);
	}

	return kmm;
    }
}






