package Freenet.message;
import Freenet.*;
import Freenet.node.Entity;
import java.util.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This is the MessageMemory pertaining to messages that need to
 * remember the keys used.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class KeyedMM extends MessageMemory {

    // Constants
    /** MessageMemory is new and not yet used **/
    public static final int NEW = 0;
    /** Reply is pending **/
    public static final int PENDING = 10;
    /** Reply received, awaiting DataSend message **/
    public static final int AWAITING_DATA = 20;
    /** Data is being received **/
    public static final int RECEIVING_DATA = 30;
    /** Data was received or interrupted and did not validate **/
    public static final int BROKEN_DATA = 35;
    /** Data was fully received and validated correctly **/
    public static final int RECEIVED_DATA = 40;
    /** Data has been stored **/
    public static final int STORED_DATA = 50;
    /** The Request has ended **/
    public static final int DONE = 60;
    
    
    // Public Fields
    
    /** Current state of the Request **/
    int state = NEW;
    
    /** The key for this request **/
    Key searchKey;
    /** The key who's reference was last attempted **/
    Key lastAttempt;
    /** The key who's reference was attempted previous to that **/
    Key prevAttempt;
    /** The Request subclass corresponding to the type of message **/
    Class messageType;
    /** All addresses that this request has previously been sent to from 
	here **/
    Vector usedAddresses;
    /** The last address this request was sent to **/
    Address lastAddr;
    /** The RequestRestarted MessageObject scheduled to restart this
	message if there is no reply **/
    RequestRestarted rr;

    /** this is the address that data is sent to, originally it is set 
	back to the sender, but can be reset for Inserts for example **/
    Address dataref;
    /** dito connection **/
    ConnectionHandler dataCon;

    /** hold the actual data before it is stored. **/
    Entity data;
    /** hold the StoreData message anticipating the receive finishing **/
    StoreData storeData;
    /** hold the SendDone messageobject anticipating store finishing **/
    SendDone sendDone;
    /** hold the QueryRestarted anticipating send failed 
	(only used on bad streams) **/
    QueryRestarted queryRestarted;
    
  // Constructor
    
    /**
     * @param origRec The address from which the Request
     *                originated
     * @param depth   The depth of the chain at this step
     * @param replyCon The connection on which the Request 
     *                 was retrieved
     * @param searchKey The key being searched for
     * @param lastAttempt The key corresponding to the most
     *                    recent attempt to send a Request
     *                    (used as a mask).
     * @param messageType The class of the Request object.
     * @param rr          The RequestRestarted object to handle on no reply
     *                    or broken one.
     **/
    public KeyedMM(Address origRec,
		   long depth,
		   ConnectionHandler replyCon,
		   Key searchKey,
		   Key lastAttempt,
		   Class messageType,
		   RequestRestarted rr) {
	super(origRec,depth, replyCon);
	this.dataref = origRec;
	this.dataCon = replyCon;
	this.searchKey = searchKey;
	this.lastAttempt = lastAttempt;
	this.prevAttempt = null;
	this.messageType = messageType;
	this.rr = rr;
	this.usedAddresses = new Vector();
    }


    /** 
     * Cancel the timer, and if it exists (meaning some node is probably 
     * waiting for response, generate a SendBack object to sendback a 
     * RequestFailed.
     * @param longid  The id of this message chain wrapped in a Long object
     *                (God knows why).
     */
    public void lost(Long longid) {
	if (state == PENDING && rr != null && rr.cancel()) {
	    SendBack sb = new SendBack(longid.longValue(), rr.hopsToLive(),
				       origRec, replyCon);
	}
    }

}






