package Freenet.message;
import Freenet.*;
import Freenet.node.*;
import Freenet.support.*;

/**
 * QueryRestarted messages are sent when the Query is restarted do to no
 * response coming back from a node, or bad data being discovered etc.
 * Since the scheduled time is relative to the hops to live, this ensures
 * that even on an error, the query is only restarted at the "deepest" possible
 * node.
 *
 * @author oskar
 */

public class QueryRestarted extends Message
{

    public static final String messageName = "QueryRestarted";

    public QueryRestarted(RawMessage m) throws InvalidMessageException
    {
	super(m);
    }

    public QueryRestarted(long idnum, long htl)
    {
	super(idnum, htl, (long)0, null);
    }

    
    public RawMessage toRawMessage(Presentation t)
    {
	RawMessage raw=super.toRawMessage(t);
	raw.messageType="QueryRestarted";
	raw.trailingFieldName="EndMessage";
	return raw;
    }


    public MessageMemory pReceived(Node n, MessageMemory sb)
    {
	if (sb==null) { // already lost mm
	    return null;
	} else {
	    if (sb instanceof KeyedMM ) {
		KeyedMM kmm = (KeyedMM) sb;

		if (!kmm.lastAddr.equals(source)) {
		    // Stale QueryRestarted from a node we gave up on
		    Core.logger.log(this,"Stale QueryRestarted from " + source
				    + ", expected from " + kmm.lastAddr,
				    Logger.DEBUGGING);
		    return sb;
		}
 
		if (kmm.state >= kmm.RECEIVING_DATA && 
		    kmm.state < kmm.RECEIVED_DATA) {
		    Core.logger.log(this, "QueryRestarted waiting for (bad) "
				    + "data to finish downloading.",
				    Logger.DEBUGGING);
		    kmm.queryRestarted = this;
		    return kmm;
		} else if (kmm.state != kmm.PENDING) { // restarting timedout chain
		    Core.logger.log(this,"Received QueryRestarted message for "
				    + "request that was not pending",
				    Logger.MINOR);
		    return kmm;
		}
	      
		if (kmm.rr != null)
		    kmm.rr.cancel();

		try {
		    sb.replyCon = sendBack(n, sb);
		    if (kmm.rr != null)
			n.timer.add(RequestRestarted.getTime(kmm.rr.hopsToLive()), 
				    kmm.rr);
		} catch (SendFailedException sfe) {
		    Core.logger.log(this,"Send failed on return to " 
				    + sfe.peer,Logger.NORMAL);
		}
	    }
	    return sb;	    
	}
    }

    protected MessageMemory timeOut(Node n, MessageMemory sb) {
	Core.logger.log(this,"Errant QueryRestarted message died",
			Logger.NORMAL);
	return null;
    }
}  







