package Freenet.message;
import Freenet.*;
import Freenet.node.*;
import Freenet.support.*;
import java.util.*;

public abstract class Request extends Message {

  public Key searchKey;

  public Request(long idnum, long htl, long depth, Key key)
  {
      super(idnum, htl, depth,null);
      searchKey=key;
  }

  public Request(RawMessage raw) throws InvalidMessageException
  {
    super(raw);
    String keyString = otherFields.get("SearchKey");
    if (keyString.equals("")) 
	throw new InvalidMessageException("Can't find SearchKey field");
    try {
	searchKey=Key.readKey(keyString);
    } catch (KeyException k) {
	throw new InvalidMessageException("Failed to load key: " + k);
    }
  }

  public RawMessage toRawMessage(Presentation t)
  {
    RawMessage raw=super.toRawMessage(t);
    raw.fs.add("SearchKey", searchKey.toString());
    return raw;
  }

  /**
   * Called by a node after it receives this message
   * @param n The node that called this message.  This should be used
   *          to make any nescessary modifications to the DataStore etc.
   * @param sb Null unless this node has been seen before.  If non-null it
   *           is the Object returned by the received method of the
   *           last message seen with this ID.
   * @return The object to be passed to any messages received in the near
   *         future with the same ID as this one.  Null if no object should
   *         be passed.
   **/
  protected MessageMemory pReceived(Node n, MessageMemory sb)
  {
    if(sb!=null) // Uh-oh! Must be a loop.
    {
        Core.logger.log(this,"loop - backtracking",Logger.MINOR);
	RequestFailed rf=new RequestFailed(id, hopsToLive, otherFields);
	try {
	    sendReply(n, rf);
	     // we expect no further connections from this node, so we close the connection after sending
	} catch(SendFailedException sfe) {
	    Core.logger.log(this,"Return to " + sfe.peer + " failed on loop",Logger.NORMAL);
	}
	return sb;
    }

    RequestRestarted rr = new RequestRestarted(id, hopsToLive);
    KeyedMM kmm=new KeyedMM(source, depth, receivedWith, searchKey, null, 
			    this.getClass(),rr);

    // do we have it?
    try {
	searchData(n, searchKey,kmm);
    }
    catch (RequestAbortException rae) {
	// this is good, means we found it
	return rae.mm;
    };

  
    // Going on forward the query
    Core.logger.log(this,"Forwarding query for " + searchKey,Logger.DEBUG);

    //    KeyedMM kmm=new KeyedMM(source, depth, receivedWith, searchKey, null, this.getClass());
    
    if (sentToNextBest(kmm, n, null)) {
	// add a timer callback to time out on no reply
	n.timer.add(RequestRestarted.getTime(hopsToLive), rr);
    }

    kmm.state = kmm.PENDING;

    return kmm;
  }
  
    protected boolean sentToNextBest(KeyedMM kmm, Node n, RequestFailed rf) {
	Address addr;
	NodeReference nr;
	boolean failed; 
	Vector brokenLinks = new Vector();
	
	do { // until the send doesn't fail
	    do { // until the reference isn't back or used;
		kmm.prevAttempt = kmm.lastAttempt;
		kmm.lastAttempt = n.ds.findClosestKey(kmm.searchKey, kmm.lastAttempt);
		try {
		    nr = n.ds.searchRef(kmm.lastAttempt);
		    addr = (nr == null ? null : nr.getAddress());
		} catch (BadAddressException e) {
		    addr = null;
		}
	    } while  (kmm.lastAttempt != null 
		      && (addr == null 
			  || (addr.equals(kmm.origRec)
			      || kmm.usedAddresses.contains(addr))));
	    
	    if (kmm.lastAttempt==null) { // Out of references
		Core.logger.log(this,"Giving up send of " + Long.toHexString(id) + ", returning to " + kmm.origRec,Logger.MINOR);
		if (rf == null)
		    rf = new RequestFailed(id, hopsToLive, otherFields);
		try {
		    rf.sendBack(n,kmm);
		} catch(SendFailedException sfe) {
		    Core.logger.log(this,"Return to " + sfe.peer + " failed on no more references",Logger.NORMAL);
		}
		return false;
	    }
	    
	    // mark that we've already tried to send to this address
	    kmm.usedAddresses.addElement(addr);
	    
	    failed = false;
	    Core.logger.log(this,"Forwarding query to " + addr,Logger.DEBUG);
	    try {
		ConnectionHandler ch = n.makeConnection(addr);
		sending(n, ch);
		ch.sendMessage(this);
	    } catch(ConnectFailedException cfe) {
		brokenLinks.addElement(kmm.lastAttempt);
		failed = true;  
	    } catch(SendFailedException sfe) {
		brokenLinks.addElement(kmm.lastAttempt);
		failed = true;
	    }
	} while (failed);

	// remove the broken references encounter (we are sure that we can send it somewhere, so it isn't the local network that is down)
	for (Enumeration e = brokenLinks.elements(); e.hasMoreElements() ;) {
	    Key badRef = (Key) e.nextElement();
	    Core.logger.log(this,"Removing link for ref " + badRef,Logger.DEBUG);
	    n.ds.removeRef(badRef);
	}

	kmm.lastAddr = addr;
	return true;
    }

    protected MessageMemory timeOut(Node n, MessageMemory mm) {
	/* this code was here, but it can't be right, because this
	   means time out on loop, and the message is still very much
	   pending on our last time through. Still, it was probably me
	   who put it here, so I must have had soem reason.
	   -oskar
       
	if (mm != null && mm instanceof KeyedMM) 
	    ((KeyedMM) mm).pending = false; 
	*/

	KeyedMM kmm=new KeyedMM(source, depth, receivedWith, searchKey, null, this.getClass(), new RequestRestarted(id, 1));
	// do we have it?
	try {
	    searchData(n, searchKey, kmm);
	}
	catch (RequestAbortException rae) {
	    // this is good, means we found it
	    return rae.mm;
	};

	return super.timeOut(n, mm);
    }


    /*
     * method should is called when RequestFailed times out. It should be 
     * overwritten to mirror the different timeout behaviour of
     * different requests
     */

    public static KeyedMM failedTimedOut(Node n, long id, KeyedMM kmm) {

	// Cancel existing timeout
	if (kmm.rr != null)
	    kmm.rr.cancel();

	TimedOut to=new TimedOut(id, kmm.depth);
    
	try {
	    to.sendBack(n, kmm);
	} catch(SendFailedException sfe) {
	    Core.logger.log(null,"Request, Sending of timeout to Failed message failed",Logger.NORMAL);
	}
	return null;
    }

    //Private & Protected methods

    /**
     * Called by pReceived() and timeOut() to see if we have the data, 
     * or at least a reference to it.
     * @param n this node
     * @param searchKey the key being sought
     * @param kmm   Same old MessageMemory
     **/
    public void searchData(Node n, Key searchKey, KeyedMM kmm)
	throws RequestAbortException {
	
	Entity doc;
	NodeReference ref;
	
	if ((doc = n.sh.find(searchKey)) != null) {
	    dataFound(doc,n,kmm);
	} else if (((doc = n.sh.find(searchKey)) != null) || 
		   ((doc = n.ds.searchData(searchKey)) != null)) {
	    // I have the data
	    dataFound(doc, n, kmm);
	}
	else if ((ref = n.ds.searchRef(searchKey)) != null) {
	    // No data, but I have a reference
	    refFound(ref, n, kmm);
	}
    }

    /**
     * This method is called if a ref is found to the searchkey of the
     * the request. To abort the current request, throw a RequestAbortException
     * containing the MM to be returned.
     **/
    protected abstract void refFound(NodeReference ref, Node n, 
				     KeyedMM kmm) throws RequestAbortException;

    /**
     * This method is called if data is found to the searchkey of the
     * the request. To abort the current request, throw a RequestAbortException
     * containing the MM to be returned.
     **/
    protected abstract void dataFound(Entity doc, Node n, KeyedMM kmm) 
	throws RequestAbortException;
}











