package Freenet.message;
import Freenet.*;
import Freenet.node.*;
import Freenet.support.*;

public class RequestCB {

    private MessageHandler mh;
    private long id;
    public long hopsToLive;

    /**
     *@param mh          The nodes MessageHandler
     *@param id          The messages id
     *@param htl         The messages hops to live left on the message
     **/
    public RequestCB(MessageHandler mh, long id, long htl)
    {
	this.mh = mh;
	this.id = id;
	this.hopsToLive = htl;
    }

    // this differs from the callback in that it sends back a requestfailed, rather then attemption to restart here. Used when pending RequestCBs are canceled because they were pushed from the MessageHandlers hashtable
    public void sendback() {
	(new SendbackThread()).start();
    }

    private class SendbackThread extends Thread {
	public SendbackThread() {
		super("RequestCD.SendbackThread");
	}
	
	public void run() {
	    mh.handle(new RequestReturn());
	}
    }

    private class RequestReturn implements MessageObject {

	public RequestReturn() {
	}

	public long id() {
	    return id;
	}

	public MessageMemory received(Node n, MessageMemory mm) {
	    try {
		Core.logger.log(this,"Failing to serve request do to overflowing MessageHandler",Logger.NORMAL);
		RequestFailed rf = new RequestFailed(id, hopsToLive,null); // unkown fields are lost here too
		rf.sendBack(n, mm);
	    } catch (SendFailedException sfe) {
		Core.logger.log(this,"Failed to fail on sendback",Logger.DEBUGGING);
	    }
	    return mm;
	}

	public void setException(Exception e) {
	    // this could be very useful
	}
    }

    public String toString() {
	return "Request Callback, for request " + Long.toHexString(id) + ", with " + hopsToLive + " hops left";
    }
    
}







