package Freenet.message;
import Freenet.*;
import Freenet.node.*;
import Freenet.support.*;
import java.lang.reflect.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This message is sent by a node which cannot locate a piece of data.
 * If received by a node, it should either forward it back to whichever
 * node sent the request to it, or should send another request to find
 * the data.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 * @author <A HREF="mailto:author2@email.addr">Author 2</A>
 **/

public class RequestFailed extends Message
{
  // Public Fields

    public final static String messageName = "RequestFailed";

  // Protected/Private Fields

  // Constructors

  public RequestFailed(RawMessage m) 
    throws InvalidMessageException
    {
      super(m);
      keepAlive = false;
    }

  public RequestFailed(long idnum, long htl, FieldSet otherfields)
    {
      super(idnum, htl, (long)0,otherfields);
      keepAlive = false;
    }

  // Public Methods

  public RawMessage toRawMessage(Presentation t)
  {
    RawMessage raw=super.toRawMessage(t);
    raw.messageType=messageName;
    return raw;
  }

  public MessageMemory pReceived(Node n, MessageMemory mm) {
      if (mm == null) {
	  // Ignore this message as we should never receive
	  // a RequestFailed that does not correspond
	  // to a DataRequest we previously forwarded.  We
	  // Must have forgotten the ID.
	  return null;
      } else if (!(mm instanceof KeyedMM)) {
	  // Ignore this as this id clearly doesn't correspond
	  // to a DataRequest.
	  return null; // < Question: Would it be better to return
	  // the mm here?  I haven't as it may lead to
	  // an errant MM blocking loads of messages
	  // but being renued every time it did.
      } else {
	  KeyedMM kmm=(KeyedMM)mm;
	    
	  if (kmm.state != kmm.PENDING) {
	      Core.logger.log(this,"Received RequestFailed message for a request that was not pending!",Logger.MINOR);
	      return kmm;
	  }
	  
	  // cancel any timer waiting for this message
	  if (kmm.rr != null)
	      kmm.rr.cancel();
	  
	  // Construct the new message of the type of class stored in 
	  // the MessageMemory
	  Request m = null;
	  try {
	      Class[] carr = {long.class,long.class,long.class,Key.class};
	      Constructor con = kmm.messageType.getConstructor(carr);
	      Object[] oarr = {new Long(id), new Long(hopsToLive), new Long(kmm.depth), kmm.searchKey};
	      m = (Request) con.newInstance(oarr);
	  } catch (Exception e) {
	      //	     return null;
	  }
	  
	  // Can this really even happen?  Shouldn't this code be in the catch 
	  // block above?
	  // it can now - oskar
	  
	  if (m == null) {
	      Core.logger.log(this, "Cannot construct new message for " + 
			      Long.toHexString(id) + 
			      ", returning Failed to " + mm.origRec, 
			      Logger.DEBUGGING);
	      try {
		  sendBack(n, kmm);
	      } catch(SendFailedException sfe) {
		  Core.logger.log(this, "Send of Failed for " + 
				  Long.toHexString(id) + " itself failed.",
				  Logger.NORMAL);
	      }
	      kmm.state = kmm.DONE;
	      return kmm;
	  }
	  
	  if (m.sentToNextBest(kmm, n, this)) {
	      if (kmm.rr != null) {
		  long callbacktime = RequestRestarted.getTime(hopsToLive);
		  Core.logger.log(this, "Re-scheduling the timeout, in " + callbacktime + " millis",
				  Logger.DEBUGGING);
		  kmm.rr.setHopsToLive(hopsToLive);
		  n.timer.add(callbacktime, kmm.rr);
	      }
	  } else {
	      kmm.state = kmm.DONE;
	  }
	  return kmm;
      }
  }

    // Protected/Private Methods

    protected MessageMemory timeOut(Node n, MessageMemory sb)
    {
	if (sb == null || sb.depth <= 0 || !(sb instanceof KeyedMM))
	    return null;

	KeyedMM kmm = (KeyedMM) sb;
	try {
	    // This exectues the static "failedTimedOut" method of the kind of Request Message this responded to
	    Class[] carr = {Node.class,long.class,KeyedMM.class};
	    Method m = kmm.messageType.getMethod("failedTimedOut",carr);
	    Object[] oarr = {n,new Long(id),kmm};
	    Object o = m.invoke(null,oarr);
	    kmm = (KeyedMM) o;
	} catch (Exception e) {
	    Core.logger.log(this,"Error in Request message class " + kmm.messageType,Logger.ERROR); 
	} finally {
	    return kmm;
	}
    }
}


