package Freenet.message;
import Freenet.*;
import Freenet.node.*;
import Freenet.support.Logger;
/**
 * SendBacks are generated an executed when the stack holding pending
 * Request MessageMemories overflows and looses messages before a reply
 * has been received.
 *
 * This is much like RequestRestarted, but a SendBack sends back a 
 * RequestFailed, rather then executing it here.
 *
 * @author oskar
 */

public class SendBack implements NodeMessageObject {

    private long id;
    private long hopsToLive;
    private ConnectionHandler replyCon;
    private Address origRec;

    /**
     * Creates a new SendBack object.
     * @param id          The id of the message chain that failed.
     * @param hopsToLive  The Hops To Live left on the request.
     * @param replyCon    A connection back to the node the Request was
     *                    received from. This may be null or already closed.
     * @param origRec     The Address of the node the Request was originally
     *                    received from.
     */
    public SendBack(long id, long hopsToLive, Address origRec, 
		    ConnectionHandler replyCon) {
	this.id = id;
	this.hopsToLive = hopsToLive;
	this.origRec = origRec;
	this.replyCon = replyCon;
    }

    public long id() {
	return id;
    }
    
    /**
     * Handles this message (sends a RequestFailed back to the previous node).
     * @param n     The current Node.
     * @param mm    Since this MessageObject is generated when the mm is
     *              dropped, it is assumed that this is null.
     */
    public MessageMemory received(Node n, MessageMemory mm) {
	try {
	    Core.logger.log(this,"Failing to serve request do to overflowing" 
			    + " MessageHandler",Logger.NORMAL);
	    // unkown fields are lost here too
	    RequestFailed rf = new RequestFailed(id, hopsToLive,null); 
	    if (replyCon == null || !replyCon.isOpen()) {
		replyCon = n.makeConnection(origRec);
	    }
	    replyCon.sendMessage(rf);
	} catch (Exception e) {
	    Core.logger.log(this,"Failed to fail on sendback: " + e,Logger.DEBUGGING);
	}
	return mm;
    }

    public void setException(Exception e) {
	// this could be very useful
    }
}

