package Freenet.message;
import Freenet.*;
import Freenet.node.*;
import Freenet.support.Logger;
import java.io.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: Node (1.0)
                    Address (1.0)
		    Message (1.0)
 */

/**
 * This is the TimedOut message
 *
 * @see Node
 * @see Address
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 **/

public class TimedOut extends Message
{

    public static final String messageName = "TimedOut";

  public TimedOut(long idnum, long htl)
    {
      super(idnum, htl, (long)0, null);
      this.keepAlive = false;
    }

  public TimedOut(RawMessage raw) throws InvalidMessageException
  {
    super(raw);
    this.keepAlive = false;
  }

  public RawMessage toRawMessage(Presentation t)
  {
    RawMessage raw=super.toRawMessage(t);
    raw.messageType="TimedOut";
    return raw;
  }

  /**
   * Called by a node after it receives this message
   * @param n The node that called this message.  This should be used
   *          to make any nescessary modifications to the DataStore etc.
   * @param sb Null unless this node has been seen before.  If non-null it
   *           is the Object returned by the received method of the
   *           last message seen with this ID.
   * @return The object to be passed to any messages received in the near
   *         future with the same ID as this one.  Null if no object should
   *         be passed.
   **/
  public MessageMemory pReceived(Node n, MessageMemory sb)  {
      if(sb==null || !(sb instanceof KeyedMM)) // No one requested this, or I forgot about it
	  return null;
      else { // Forward it to whoever requested it.
	  KeyedMM kmm = (KeyedMM) sb;

	  if (kmm.state != kmm.PENDING) {
	      Core.logger.log(this,"Received TimedOut message for request that was not pending",Logger.MINOR);
	      return kmm;
	  }

	  if (kmm.rr != null)
	      kmm.rr.cancel();

	  try {
	      sendBack(n, sb);
	  } catch (SendFailedException sfe) {
	      Core.logger.log(this,"Send failed on return to " + sfe.peer,Logger.NORMAL);
	  }

	  kmm.state = kmm.DONE;
	  return null;
    }
  }

    protected MessageMemory timeOut(Node n, MessageMemory sb)
    {
	Core.logger.log(this,"Errant TimedOut message died",Logger.NORMAL);
	return sb;
    }
}


