package Freenet.node;
import Freenet.*;
import Freenet.support.*;
import Freenet.support.io.ControlInputStream;
import java.io.*;
import java.util.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

/**
 * This class is used to store data.  The object creates a file on disk
 * in a (statically specified) directory to store the data in.  In general
 * the data is accessed using streams.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public interface Data
{

    /**
     * @return Whether this object contains readable data
     **/
    public boolean isReadable();

    /**
     * Returns a long which specifies the length of the data stored in this
     * object
     **/
    public long getLength() throws BadDataException;

    /**
     * Returns an InputStream which supplies the data stored in this
     * object. This inputstream must read correctly even before the 
     * data has finished loading (it should lock on read when there
     * is no more to read but the data has not been loaded yet).
     *
     * Implementations of Data must keep track of all instances of 
     * streams reading from the data, so they can be stopped correctly
     * with stopStreams.
     *
     * @return     A ControlInputstream reading this data.
     **/
    public ControlInputStream getInputStream() 
	throws BadDataException, IOException;

    /**
     * Stops loading data into this object if it is not finished.
     **/
    public void stop() throws BadDataException, IOException;

    /**
     * Stop all reading InputStreams at their next control character.
     * @param endChar The control character to send as the next (and final)
     *                control character to the streams.
     **/
    public void stopStreams(int endChar);
    
}








