package Freenet.node;
import Freenet.FieldSet;
import java.util.Enumeration;
import java.io.PrintWriter;
import java.io.PrintStream;
import java.io.IOException;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/


/**
 * This class is used to store properties associated with data. 
 *
 * @author <a href="http://www.doc.ic.ac.uk/~twh1/">Theodore Hong</a>
 * @author oskar
 **/

public abstract class DataProperties {

    /**
     * This exception is thrown when restore is attempted where
     * nothing has been stored, or when store is attempted a 
     * second time (without delete).
     **/
    public static class WrongOrderException extends Exception {
	public WrongOrderException() {
	    super();
	}
    }

    /**
     * Store the properties contained in the FieldSet.
     **/
    public abstract void store(FieldSet fs) 
	throws IOException, DataProperties.WrongOrderException;

    /**
     * Restore these properties from storage.
     **/
    public abstract FieldSet restore() 
	throws IOException, DataProperties.WrongOrderException;

    /**
     * Return the length of the data properties after being
     * stored. If they are not stored 0 may be returned.
     **/
    public abstract long length();

    /**
     * Remove the data from storage.
     **/
    public abstract void delete() throws IOException;

    /**
     * Whether data properties have been saved.
     **/
    public abstract boolean isSaved();

    /**
     * Remove from storage when finalized, delete is called.
     **/
    protected void finalize() throws Throwable
    {
	delete();
	super.finalize();
    }

}
