package Freenet.node;
import Freenet.Key;
import Freenet.support.io.SplitOutputStream;
import java.io.Serializable;
import java.io.IOException;
import java.io.File;

public interface DataStore extends Serializable {

    //    public void tofile(String filename) throws IOException;

  /**
   * Searches for a key in the DataStore and if found returns
   * the entity associated with that key.  If none is found,
   * null is returned.
   * @param k The key to search for
   * @return The entity associated with the key or null if not found
   **/
    public Entity searchData(Key k);

  /**
    * Searches for a key in the DataStore and if found returns
    * the reference associated with that key.  If none is found,
    * null is returned.
    * @param k The key to search for
    * @return The reference associated with the key or null
    *         if not found
    **/
    public NodeReference searchRef(Key k);
    /**
     * Removes an item from the DataStore given its key
     * @param k The key of the item to remove
     **/
    public void remove(Key k);
    /**
     * Removes the reference for a given key. If there is no
     * document stored under this key, the entry will be removed
     * completely
     * @param k The key of item who's reference to remove
     **/
    public void removeRef(Key k);
  /**
    * Returns the reference associated with the closest key
    * to k.
    * @param k The key to search for
    * @return The closest Key to k
    **/
    public Key findClosestKey(Key k);
  /**
    * Returns the reference associated with the closest key
    * to k.  The masking key allows the 'next best' key to
    * be found.  Imagine the entries in the datastore being
    * sorted in terms of closeness to the key you specify.
    * With no mask key the reference associated with the
    * top-most item will be returned.  However, with a mask
    * key any references associated with keys above the mask
    * key (including the mask key itself) will be ignored.
    * This facility allows best-first backtracking.
    * @param k The key to search for
    * @param maskKey The masking key (or null for no mask)
    * @return The closest Key to k (excluding masked keys) or
    *         null if all keys are masked.
    **/
    public Key findClosestKey(Key k, Key maskKey);
  /**
    * Adds an item to the DataStore
    * @param k The key to add
    * @param r The address to which requests should be directed for
    *          this key if the data is removed
    * @param d The data associated with this key
    **/
    public void put(Key k, NodeReference r, Entity d);
    /**
     * Creates an Entity that reads data off a
     * SplitOutputStream as it is being written too.
     * @param datatunnel SplitOutputStream to read data from
     * @param length     Number of bytes to read into this object
     * @param partLength After how many bytes to expect a control
     *                   byte in this object. If 0 a byte should only
     *                   be expected last.
     * @return           A new Entity object.
     */
    public Entity newEntity(SplitOutputStream datatunnel, long length, long partLength) throws IOException;
}



