package Freenet.node;
import Freenet.*;
import Freenet.support.Logger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.io.File;
import java.io.IOException;
/**
 * This class is used to schedule and execute housekeeping duties for 
 * the StandardDataStore.
 * 
 * @author oskar
 **/

public class DataStoreMaintence implements NodeMessageObject {

    private long id;
    
    /**
     * Creates a new DataStoreMaintence object
     * @param mh  The MessageHandler to execute the maintence when it wakes up.
     **/
    public DataStoreMaintence(long id) {
	this.id = id;
    }

    /**
     * Schedules this maintence object for execution in 
     * StandardDataStore.checkpointInterval seconds.
     **/
    public void schedule(Node n) {
	Core.logger.log(this,"Scheduling checkpoit in " + 
			StandardDataStore.checkpointInterval + " seconds.",
			Logger.DEBUGGING);
	n.timer.add(StandardDataStore.checkpointInterval * 1000, 
		    this);
    }

    /**
     * The id of DataStoreMaintence all objects is fixed at 23, so only
     * one can be executed at a time. 
     **/
    public long id() {
	return id;
    }

    /**
     * Stores the current datastore to disk an reschedules itself.
     **/
    public MessageMemory received(Node n, MessageMemory mm) {
	if (!(n.ds instanceof StandardDataStore)) {
	    Core.logger.log(this,"Can only work on StandDataStore objects",
			    Logger.ERROR);
	    return mm;
	} else {
	    StandardDataStore ds = (StandardDataStore) n.ds; 
	    try {
		ds.tofile();
	    } catch (IOException e) {
		Core.logger.log(this,"Failed to write DataStore to disk: " + e,
				Logger.NORMAL);
	    }
	    schedule(n);
	}
	return mm;
    }

    public void cleardir(StandardDataStore ds) {
	Hashtable files = new Hashtable();
	for (Enumeration e = ds.data(); e.hasMoreElements() ;) {
	    Object o = e.nextElement();
	    if (o instanceof FileEntity) {
		FileEntity fe = (FileEntity) o;
		if (fe.fileData() != null)
		    files.put(fe.fileData().fileName(),o);
		if (fe.fileProps() != null && 
		    fe.fileProps().fileName() != null)
		    files.put(fe.fileProps().fileName(),o);
	    } else {
		Core.logger.log(this,"Can't handle Entity of type " +
				o.getClass().getName(),Logger.MINOR);
	    }
	}

	File[] dirs = (FileData.path.equals(FileDataProperties.path) ? 
		       new File[] {FileData.path} : 
		       new File[] {FileData.path , 
				   FileDataProperties.path});
	for (int j = 0 ; j < dirs.length ; j++) {
	    String[] indir = dirs[j].list();
	    String fullname;
	    for (int i = 0 ; indir != null && i < indir.length; i++) {
		if (indir[i].startsWith("t")) {
		    fullname = dirs[j].getPath() + File.separator + indir[i];
		    Object o = files.get(fullname);
		    if (o == null) {
			Core.logger.log(this, "Removing file " + fullname, 
					Logger.DEBUGGING);
			(new File(fullname)).delete();
		    }
		}
	    }
	}
    }   

    public void setException(Exception e) {
	// not expecting any exceptions
    }
}




