package Freenet.node;
import Freenet.*;
import Freenet.support.Logger;
import java.net.*;
import java.io.*;

/**
 * This class delays the InformWrite for a period of time, to filter out
 * short-lived nodes.
 * 
 * Based heavily on DataStoreMaintence.
 * 
 * @author coates
 */

public class DelayInformWrite implements NodeMessageObject {

    private long id;

    /**
     * Creates a new DelayInformWrite object
     **/
    public DelayInformWrite(long id) {
        this.id = id;
    }

    /**
     * Schedules InformWrite for execution in delay seconds.
     * @param delay  Delay, in seconds.
     **/
    public void schedule(Node n, long delay) {
        Core.logger.log(this,"Scheduling InformWrite in " + delay +
                        " seconds.", Logger.DEBUGGING);

        n.timer.add(delay * 1000, this);
    }

    public long id() { return id; }

    /**
     * Calls InformWrite.
     **/
    public MessageMemory received(Node n, MessageMemory mm) {
        // Rather than screw around with trying to call the Node inform 
        // routines, I'm just repeating them here.
        try {
	    Core.logger.log(this,
			    "Doing Delayed InformWrite",
                            Logger.DEBUGGING);

            URL u = new URL(n.params.getParam("informURL", 
                                            n.defaultInformUrl));

            HttpURLConnection c = (HttpURLConnection) (u.openConnection());
            c.setDoInput(true);
            c.setDoOutput(true);
            c.setUseCaches(true);

            c.setRequestProperty("Content-type",
                                 "application/x-www-form-urlencoded");
            PrintWriter outStream = new PrintWriter(c.getOutputStream());
	    String hostName=n.params.getParam("nodeAddress");
	    if (hostName==null)  
		outStream.print("port="+n.params.getParam("listenPort"));
	    else 
		outStream.print("write=tcp/"+hostName+":"+
				n.params.getParam("listenPort"));

            outStream.close();

            BufferedInputStream bis = new BufferedInputStream(c.getInputStream());
            byte[] trashbuffer = new byte[1024];
            do; while (bis.read(trashbuffer) != -1);

            c.disconnect();

	} catch (Exception e) {
	    Core.logger.log(null,
			    "DelayedInform Connection failed:"+e,
                            Logger.ERROR);
	}

        return null; // is this right?
    }
    
    public void setException(Exception e) {
        // not expecting exceptions.
    }
}
    
