package Freenet.node;
import java.io.Serializable;
import java.io.DataOutputStream;
import java.io.IOException;
import Freenet.support.Logger;
import Freenet.Core;
import Freenet.FieldSet;
/**
 * Represents a Freenet document or data parcel.
 * An entity = data (Data) + intrinsic metadata (DataProperties).
 *
 * Intrinsic metadata describes fundamental aspects of this data specified
 * by the author at insertion time, without which the data cannot be 
 * interpreted, and which make no sense independent of the data -- 
 * underlying compression method, encryption method, etc.
 * This class may later be extended with other types of metadata.
 *
 * @author <a href="http://www.doc.ic.ac.uk/~twh1/">Theodore Hong</a>
 **/

public abstract class Entity implements Serializable {

    protected Data data;
    protected DataProperties props;

    protected Entity(Data data, DataProperties props) {
	this.data = data;
	this.props = props;
    }

    protected Entity() {
    }


    /**
     * @return Data object of this document
     **/
    public Data data() {
	return data;
    }

    /**
     * @return DataProperties of this document
     **/
    public DataProperties props() {
	return props;
    }

    /**
     * @return Total length of data and properties
     **/
    public long length() {
	try {
	    return (data == null ? 0 : data.getLength()) + (props == null? 0 : props.length());
	} catch (BadDataException e) {
	    Core.logger.log(this,"Length read attempted on bad entity",
			    Logger.ERROR);
	    return props == null? 0 : props.length();
	}
    }

    /**
     * Write information needed to restore this document to
     * a stream. 
     * @arg dos The stream to write to.
     **/
    public abstract void write(DataOutputStream dos) throws IOException;

    /**
     * Write information need to restore this entity to a FieldSet
     * @arg fs  The FieldSet to write to
     **/
    public abstract void write(FieldSet fs);

    public String toString() {
	return data.toString();
    }
}
