package Freenet.node;
import Freenet.*;
import Freenet.support.*;
import Freenet.support.io.ReadInputStream;
import Freenet.support.io.WriteOutputStream;
import java.io.*;
import java.util.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/


/**
 * This class is used to store properties associated with data.  If
 * requested, the object creates a file on disk alongside its associated
 * Data file.
 *
 * @author <a href="http://www.doc.ic.ac.uk/~twh1/">Theodore Hong</a>
 **/

public class FileDataProperties extends DataProperties {

    public static void main(String[] args) throws Exception {
	DataProperties hello = new FileDataProperties(new File(args[0]));
	FieldSet fs = hello.restore();
	System.out.println(fs.toString());

	DataProperties hello2 = new FileDataProperties("lala");
	hello2.store(fs);
	System.out.println(hello2.restore().toString());
	
    }


    /** The path where property files should be stored **/
    public static File path;
    public static String suffix = ".inf";
    public static String descriptor = "Freenet properties file";

    protected File name;
    protected long length;
    private String filename;
    protected boolean delFile = true;

    /**
     * Creates a new data properties item.
     *
     * @param data The data that these properties are associated to.
     **/
    public FileDataProperties(FileData data) {
	this.filename = data.name.getName() + suffix;
    }


    /**
     * Loads a data properties item from the specified file.
     * NOTE: The file <B>will</B> be deleted when this object
     * is finalized.
     *
     * @param name The file in which the data properties are stored.
     * @see fileName
     **/
    public FileDataProperties(File name) {
	this.name = name;
	this.filename = name.getName();
	this.length = name.length();
    }

    public FileDataProperties(String filename) {
	this.filename = filename;
    }


    public void store(FieldSet fs)
	throws IOException, DataProperties.WrongOrderException {

	if (name != null)
	    throw new DataProperties.WrongOrderException();
	name = new File(path, filename);
	FileOutputStream out = new FileOutputStream(name);
	WriteOutputStream pw = new WriteOutputStream(out);
	fs.writeFields(pw, 
		       descriptor, 
		       '\n',
		       '=',
		       '.');
	pw.flush();
	length = name.length();
    }

    public FieldSet restore() 
	throws IOException, DataProperties.WrongOrderException {
	
	if (name == null)
	    throw new DataProperties.WrongOrderException();

	FileInputStream in = new FileInputStream(name);
	ReadInputStream ris = new ReadInputStream(in);

	FieldSet fs = new FieldSet();
	fs.parseFields(ris,
		       '\n',
		       '=',
		       '.');
	return fs;
    }
	       


    /**
     * @return Whether the properties have been written to a file
     **/
    public boolean isSaved() {
	return name != null;
    }

    /**
     * @return The name of the file or "(in RAM)" if it unsaved
     **/
    public String toString() {
	if (name != null)
	    return name.toString();
	else
	    return "(in RAM)";
    }

    /**
     * @return The name of the file or null if unsaved
     **/
    public String fileName() {
	return name == null ? null : name.getPath();
    }


    public long length() {
	if (name != null)
	    return length;
	else
	    return 0;
    }

    public void delete() throws IOException {
	name.delete();
	name = null;
    }

}
