package Freenet.node;
import java.io.*;
import Freenet.FieldSet;
import Freenet.support.Logger;
import Freenet.support.io.SplitOutputStream;
/**
 * Represents a Freenet document.
 * A document = data (Data) + intrinsic metadata (DataProperties).
 *
 * Intrinsic metadata describes fundamental aspects of this data specified
 * by the author at insertion time, without which the data cannot be 
 * interpreted, and which make no sense independent of the data -- 
 * underlying compression method, encryption method, etc.
 * This class may later be extended with other types of metadata.
 *
 * This class is complete, but abstract. The correct way to create an
 * instance is using the newEntity method of the StandardDataStore.
 *
 * @author <a href="http://www.doc.ic.ac.uk/~twh1/">Theodore Hong</a>
 **/

public abstract class FileEntity extends Entity implements Serializable {

    public FileData fileData() {return (FileData) data;}

    public FileDataProperties fileProps() {return (FileDataProperties) props;}

    protected FileEntity(SplitOutputStream datatunnel, long datalength, long dataPartLength) throws IOException {
	super();
	this.data = new FileData(datatunnel, datalength, dataPartLength);
	this.props = new FileDataProperties((FileData) data);
    }

    protected FileEntity(FieldSet fs) {
	this(fs.get("Data"),fs.get("DataProperties"));
    }

    protected FileEntity(DataInputStream in) throws IOException {
	this(in.readUTF(),in.readUTF());
    }

    private FileEntity(String dataString, String propString) {

	super();

	if (dataString != null && !dataString.equals(""))
	    data = new FileData(new File(dataString));
	if (propString != null && !propString.equals("")) 
	    props = new FileDataProperties(new File(propString));
	else
	    props = new FileDataProperties((FileData) data);
    }

    public void write(DataOutputStream dos) throws IOException {
	FileData fdata = (FileData) data;
	FileDataProperties fprops = (FileDataProperties) props;
	dos.writeUTF(fdata == null ? "" : fdata.fileName());
	if (fprops == null) {
	    dos.writeUTF("");
	} else {
	    dos.writeUTF(fprops.isSaved() ? fprops.toString() : "");
	}
    }

    public void write(FieldSet fs) {
	if (fileData() != null)
	    fs.add("Data",fileData().fileName());
	if (fileProps() != null && fileProps().isSaved())
	    fs.add("DataProperties",fileProps().toString());
    }
}
