package Freenet.node;
import Freenet.*;
import Freenet.crypt.*;
import Freenet.support.*;
import Freenet.support.io.*;
import Freenet.presentation.FreenetProtocol;
import Freenet.keys.KHK;
import java.util.*;
import java.net.*;
import java.io.*;

public class InformThread implements Runnable {
    
    private Hashtable at;
    private String url;
    private Params params;
    private Node n;
    
    public InformThread(Hashtable at, String url, Params params, Node n) {
	this.at = at;
	this.url = url;
	this.params = params;
	this.n = n;
	if ((params.getlong("informDelay", n.defaultInformDelay) != 0)
		&& (params.getboolean("informWrite", n.defaultInformWrite))) {
	    DelayInformWrite diw = new DelayInformWrite(Core.randSource.nextLong());
	    diw.schedule(n, params.getlong("informDelay", n.defaultInformDelay));
	}
	(new Thread(this)).run();
    }
    
    public void run() {
	try {
	    HttpURLConnection c = (HttpURLConnection) (new URL(url)).openConnection();
	    c.setDoInput(true);
	    c.setDoOutput(true);
	    c.setUseCaches(true);
	    informWrite(c);
	    informRead(c, at);
	    c.disconnect();
	} catch (Exception e) {
	    Core.logger.log(null, "Inform Connection failed:"+e, Logger.ERROR);
	}
    }

    private void informWrite(HttpURLConnection c) throws IOException {
	if ((params.getboolean("informWrite", n.defaultInformWrite))
	        && (params.getlong("informDelay", n.defaultInformDelay) == 0)) {
	    c.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
	    PrintWriter outStream = new PrintWriter(c.getOutputStream());
	    String hostName=n.params.getParam("nodeAddress");
	    if (hostName==null) outStream.print("port="+n.params.getParam("listenPort"));
	    else outStream.print("write=tcp/"+hostName+":"+n.params.getParam("listenPort"));
	    outStream.close();
	}
    }

    private void informRead(HttpURLConnection c, Hashtable at) throws IOException {
	if (params.getboolean("informRead", n.defaultInformRead)) {
	    InputStreamReader ir = new InputStreamReader(c.getInputStream());
	    BufferedReader br = new BufferedReader(ir);
	    SHA1 sha=new SHA1(true);
	    while(br.ready()) {
		String addrstr=br.readLine();
		addrstr=addrstr.trim();
		if(addrstr.startsWith(n.BUILD)) {
		    String latestbuild = addrstr.substring(n.BUILD.length());
		    if (n.buildNumber.compareTo(latestbuild) < 0)
			System.err.println("Newer build "+latestbuild+
			" is available than this build "+n.buildNumber+", please upgrade!");
		} else if(!addrstr.equals("")) {
		    Key tname = KHK.makeKHK(addrstr);
		    if(n.ds.searchRef(tname)==null) at.put(addrstr, tname);
		}
	    }
	    ir.close();
	} else {
	    BufferedInputStream bis = new BufferedInputStream(c.getInputStream());
	    byte[] trashbuffer = new byte[1024];
	    do; while (bis.read(trashbuffer) != -1);
	}
    }
}

	
