package Freenet.node;
import Freenet.MessageObject;
import Freenet.MessageMemory;

/**
 * NodeMessageObject's represent internal MessageObjects in the node.
 *
 * @author oskar
 */

public interface NodeMessageObject extends MessageObject {

    /**
     * This is the method called when this MesageObject is handled.
     * MessageObjects with the same ID are called one by one.
     * @param n   The node that the MessageObject was received by.
     * @param mm  A MessageMemory object pertaining to this Message
     *            chain.
     * @return    mm or a MessageMemory to replace mm if the chain is
     *            expected to continue. null if the chain ends here.
     */
    public MessageMemory received(Node n, MessageMemory mm);


}
