package Freenet.node;
import Freenet.*;

/**
 * References contains names from which Address objects can be resolved.
 * How this is done is transport dependant.
 *
 * It is expected that at some later time References will be more complex
 * structures contain the names for several different transports and internal
 * lookup and authorization information.
 *
 * @author oskar
 **/

public class NodeReference {

    private String name;
    private String transport;

    /**
     * Creates a new new nodereference from its full name. 
     * @param ref The transport qualified name of this reference as returned 
     * by getName().
     * @exception IllegalArgumentException - if a protocol and reference 
     *            cannot be parsed from the string.
     **/
    public NodeReference(String ref) throws IllegalArgumentException {
	int slash = ref.indexOf('/');
	if (slash <= 0 || slash == (ref.length() - 1))
	    throw new IllegalArgumentException();
	this.transport = ref.substring(0,slash);
	this.name = ref.substring(slash+1,ref.length());
    }

    /**
     * Constructs a new NodeReference object from a transport and 
     * a reference name.
     **/
    public NodeReference(String transport, String name) {
	this.transport = transport;
	this.name = name;
    }

    /**
     * Constructs a new NodeReference to this address.
     */
    public NodeReference(Address addr) {
	this.transport = addr.transport();
	this.name = addr.address.toString();
    }

    /**
     * Returns an address pointing at this reference.
     */
    public Address getAddress() throws BadAddressException {
	return new Address(transport,name);
    }

    public String getName() {
	return transport+"/"+name;
    }

    public String toString() {
	return getName();
    }
}












