package Freenet.node;

import java.io.*;
import java.util.*;
import Freenet.FieldSet;
import Freenet.support.*;
import Freenet.servlet.*;
import Freenet.client.*;
import Freenet.*;

/**
 * Launches various interfaces to the node, as specified in the params.
 *
 * @author <a href="mailto:blanu@uts.cc.utexas.edu>Brandon Wiley</a>
 **/

public class ServiceLauncher
{
  protected ThreadGroup tg;

  public ServiceLauncher(NodeReference node, FieldSet params)
  {
    if(params==null)
      return;
    ThreadGroup tg=new ThreadGroup("Freenet Services");
    Enumeration iterator = params.keys();
    while(iterator.hasMoreElements())
    {
      String name=(String)iterator.nextElement();
      FieldSet args=params.getSet(name);
      String cls=args.get("class");
      String configfile=args.get("config");
      Params p;
      try {
	  p= new Params(configfile);
	  Core.logger.log(this, "Set params from config file for " + name, Logger.MINOR);
      }
      catch(FileNotFoundException e) {
	  Core.logger.log(this, "Setting params from field set for " + name, Logger.MINOR);
	  p= new Params();
	  Enumeration fieldSetKeys = args.keys();
	  while (fieldSetKeys.hasMoreElements()) {
	      String key = (String) fieldSetKeys.nextElement();
	      // XXX: won't work with more FieldSets.
	      p.setParam(key, args.get(key));
	  }
      }
      if (cls.length() != 0)
      {
        String port=args.get("port");
	String allowhosts = args.get("allowedhosts");
	if (p.getParam("serverAddress") == null) {
	    Core.logger.log(this, "Setting serverAddress to local node (" + node.toString() + ") for " + name, Logger.MINOR);
	    p.setParam("serverAddress", node.toString());
	}

	Core.logger.log(this, "Lauching "+name, Logger.NORMAL);

        ServletHandler sh=null;

        try
        {
          sh=new ServletHandler(tg, name, new ListeningAddress("tcp/"+port), new ServletConstructor(cls, p), allowhosts);
        }
        catch(Exception e)
        { 
  	Core.logger.log(this, "Couldn't launch service "+name+": "+e, Logger.ERROR); 
        e.printStackTrace();
        }

        if(sh!=null)
          sh.start();
      }
    }
  }

  public void launch()
  {
  }
}
