package Freenet.node;
import Freenet.*;

import java.util.*;
import java.io.IOException;
/**
 * The StreamHandler keeps track of streams currently going through this node
 * so that they can be forked, and stopped if they no longer have any targets.
 * @author oskar
 **/

public class StreamHandler {

    private class Container {

	private Vector readers;
	private Entity e;
       
	public Container(Entity e, long id) {
	    this.e = e;
	    readers = new Vector(3);
	    readers.addElement(new Long(id));
	}

	public Entity getEntity() {
	    return e;
	}

	public void addReader(long id) {
	    readers.addElement(new Long(id));
	}

	public void removeReader(long id) {
	    readers.removeElement(new Long(id));
	}

	public boolean hasReaders() {
	    return !readers.isEmpty();
	}

	public Enumeration readers() {
	    return readers.elements();
	}

    }

    private Hashtable streams = new Hashtable();


    /**
     * Create a new StreamHandler.
     * @param n The node that for which this object is handeling the streams.
     **/
    public StreamHandler(Node n) {
    }

    /**
     * Add a new stream.
     * @param k      The key of the data being streamed.
     * @param id     The id of the message chain for which the data is 
     *               originally being passed.
     * @param e      The Entity containing the stream. 
     **/
    public void addStream(Key k, long id, Entity e) {
	streams.put(k,new Container(e,id));
    }

    /**
     * Adds a new reader of this stream.
     * @param k      The key of the data stream.
     * @param id     The id of the message chain of the new reader.
     **/
    public void addReader(Key k, long id) {
	Object o = streams.get(k);
	if (o != null && o instanceof Container)
	    ((Container) o).addReader(id);
    }

    /**
     * Remove a reader that has stopped reading a stream. As a side effect
     * this method will send stop() to the entity if there are no more readers.
     * @param k      The key of the data stream.
     * @param id     The id of the message chain of the old reader.
     **/
    public void removeReader(Key k, long id) {
	Object o = streams.get(k);
	if (o != null && o instanceof Container) {
	    Container c = (Container) o;
	    c.removeReader(id);
	    if (!c.hasReaders()) {
		streams.remove(k);
		try {
		    c.getEntity().data().stop();
		} catch (BadDataException e) {
		} catch (IOException e) {
		}
	    }
	}
    }

    /**
     * Get an Enumeration of the readers reading data for Key.
     * @param k      The key of the data stream.
     * @return An Enumeration of the ids of the messages reading
     *         the data, wrapped in Long s.
     **/

    public Enumeration getReaders(Key k) {
	Object o = streams.get(k);
	return ((o != null && o instanceof Container) ?
		((Container) o).readers() :
		new EmptyEnumeration());
		
    }

    private class EmptyEnumeration implements Enumeration {
	public boolean hasMoreElements() {
	    return false;
	}
	public Object nextElement() throws NoSuchElementException {
	    throw new NoSuchElementException();
	}
    }

    /**
     * Finds a live stream for a current key if there is one.
     * @param k      The key of the data stream.
     * @return The entity containing the stream if it can be found,
     *         otherwise null.
     **/
    public Entity find(Key k) {
	Object o = streams.get(k);
	return ((o != null && o instanceof Container) ?
		((Container) o).getEntity() :
		null);
    }

    /**
     * Removes a stream for a key if there is one.
     * @param k      The key of the data stream.
     * @return The entity removed if one was removed, otherwise null.
     **/
    public Entity remove(Key k) {
	Object o = streams.remove(k);
	return ((o != null && o instanceof Container) ?
		((Container) o).getEntity() :
		null);
    }
}

