package Freenet.node.gui;

import Freenet.node.Node;
import java.awt.*;
import java.awt.event.*;

/**
 * About dialog containing basic info about the Freenet node.
 *
 * @author <a href="mailto:anthony@takahe.net">Anthony Jones </a>
 **/

class AboutDialog extends Dialog {
    
    /**
     * Constructs a modal frame containing text about the Freenet node.
     * @param frame The frame which owns the dialog.  
     **/

    public AboutDialog(Frame frame) {
        super(frame, true);
        
        setTitle("About Freenet " + Node.freenetVersion);
        add(createText(), BorderLayout.CENTER);
        add(createOkButton(), BorderLayout.SOUTH);
        pack();

        // Set the position of the window so it's centred around the
        // centre of the parent window.

	Dimension size = getSize();
	Dimension frameSize = frame.getSize();
	Point framePos = frame.getLocation();
	setLocation(framePos.x + (frameSize.width - size.width) / 2,
		    framePos.y + (frameSize.height - size.height) / 2);

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                dispose();
            }
        });
    }
    
    /**
     * Creates a TextArea containing the about text.  This text area
     * is set non-editable.
     * @return The TextArea
     **/
    protected Component createText() {
        TextArea ta = new TextArea("Java Adaptive Network Client by Ian Clarke, Brandon Wiley, Oskar Sandberg, Scott G. Miller and many others.  It is distributed under the GNU Public Licence (GPL) version 2.  See  http://www.gnu.org/ for further details of the GPL.", 5, 30, TextArea.SCROLLBARS_NONE);
	ta.setEditable(false);
        return ta;
    }
    
    /**
     * Creates an OK button and adds an ActionListener for it.
     * @return The OK button object.
     **/
    protected Button createOkButton() {
        Button b = new Button("OK");
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
        return b;
    }
    
}
