package Freenet.node.gui;

import Freenet.Params;

import java.awt.*;
import java.awt.event.*;

public class BooleanSetting extends Panel implements Setting, FocusListener {

    protected Params params;
    protected String name;
    protected String id;
    protected boolean dfl;
    protected Checkbox checkbox;
    protected Label label;
    protected Help help;
    
    public BooleanSetting(Params params, Help help, String name, String id, boolean dfl) {
	super(new BorderLayout());

	this.params = params;
	this.help = help;
	this.name = name;
	this.id = id;
	this.dfl = dfl;

	label = new SettingLabel(name);
	add(label, BorderLayout.WEST);

	checkbox = createCheckbox();
	add(checkbox, BorderLayout.CENTER);
    }

    protected boolean evaluateState(String id, boolean dfl) {
	String value = params.getParam(id, dfl ? "yes" : "no"); 
	return value.equalsIgnoreCase("yes");
    }

    protected Checkbox createCheckbox() {
	Checkbox checkbox = new Checkbox();
	checkbox.setState(evaluateState(id, dfl));
	checkbox.addFocusListener(this);
	return checkbox;
    }

    public void focusGained(FocusEvent e) {
	help.set(id);
    }

    public void focusLost(FocusEvent e) {
	help.clear(id);
    }

    public boolean verify() {
	return true;
    }

    protected boolean getState() {
	return checkbox.getState();
    }

    public void update() {
	params.setParam(id, getState() ? "yes" : "no");
    }

}
