package Freenet.node.gui;

import Freenet.Core;
import Freenet.Params;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.io.File;
import java.io.FileNotFoundException;

public class Config extends Frame implements ItemListener {

    protected Params params;
    protected SettingsPanel[] cards;
    protected Container cardPanel;
    protected CardLayout cardPanelLayout;
    protected List tabPanel;
    protected Component buttonPanel;
    protected Help help;
    protected String filename;
    static final Font tabFont = new Font("SanSerif", Font.PLAIN, 12);

    public static void main(String args[]) throws Exception {
	if (args.length != 1) {
	    System.err.println("usage: freenet_config <config file>");
	    System.exit(1);
        }
	Config config = new Config(args[0]) {
	    public void dispose() {
		super.dispose();
		System.exit(0);
	    }
	};
	config.show();
    }

    public Config(String filename) {
	this.filename = filename;
	init(this.filename);
    }

    public Config() {
	// This works out what to call the config file.  It finds the last one
	// in the list which exists - this is the one which is read last and therefore
	// can override all the other files.
	//
	// If there are no config files already existing then just choose the first
	// name.
	String[] filenames = Params.defaultRCFiles;
	this.filename = filenames[0];
	for (int i = filenames.length - 1; i > 0; i--) {
	    String filename = filenames[i];
	    if ((new File(filename)).exists()) {
		this.filename = filename;
		break;
	    }
	}

	init(this.filename);
    }

    protected void init(String filename) {
	setTitle("Freenet configurator " + Core.freenetVersion);

	try {
	     params = new Params(filename);
	}
	catch (FileNotFoundException e) {
	     // Oh well.. just continue
	}

        addComponents(params);
	addWindowListener(new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {
		actionCancel();
	    }
	});
	setSize(640, 400);
        validate();
    }

    protected void addComponents(Params params) {
	setLayout(new BorderLayout());

	help = new Help();
	cards = createCards(params, help);
	cardPanel = createCardPanel(cards);  // Also sets cardPanelLayout

	Panel p = new Panel(new BorderLayout());
	p.add(cardPanel, BorderLayout.CENTER);
	p.add(help, BorderLayout.SOUTH);
	add(p, BorderLayout.CENTER);

	tabPanel = createTabs();
	add(tabPanel, BorderLayout.WEST);

	buttonPanel = createButtonPanel();
	add(buttonPanel, BorderLayout.SOUTH);
    }

    protected SettingsPanel[] createCards(Params params, Help help) {
	SettingsPanel[] cards = new SettingsPanel[7];
	cards[0] = (new NetworkSettings(params, help));
	cards[1] = (new StoreSettings(params, help));
	cards[2] = (new InformSettings(params, help));
	cards[3] = (new RoutingSettings(params, help));
	cards[4] = (new TimingSettings(params, help));
	cards[5] = (new LoggingSettings(params, help));
	cards[6] = (new FProxySettings(params, help));
	
	return cards;
    }

    protected Panel createCardPanel(SettingsPanel[] cards) {
        cardPanelLayout = new CardLayout();
	Panel cardPanel = new Panel(cardPanelLayout);
 
	for (int i = 0; i < cards.length; i++)
	    cardPanel.add(cards[i], cards[i].getName());

	return cardPanel;
    }

    protected List createTabs() {
	List tabPanel = new List();

	tabPanel.setForeground(Color.blue);
	tabPanel.setFont(tabFont);
	for (int i = 0; i < cards.length; i++)
	    tabPanel.add(cards[i].getName());

	tabPanel.addItemListener(this);
	tabPanel.select(0);

	return tabPanel;
    }

    public void itemStateChanged(ItemEvent e) {
	if (e.getStateChange() == ItemEvent.SELECTED) {
	    showCard();
        }
    }

    protected void showCard() {
	cardPanelLayout.show(cardPanel, tabPanel.getSelectedItem());
    }

    protected Component createButtonPanel() {
	Button buttonOk = new Button("Ok");
	buttonOk.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		actionAccept();
	    }
	});

	Button buttonCancel = new Button("Cancel");
	buttonCancel.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		actionCancel();
	    }
	});

	Panel panel = new Panel(new GridLayout(1, 2));
	panel.add(buttonOk);
	panel.add(buttonCancel);
	return panel;
    }

    protected boolean verify() {
	for (int i = 0; i < cards.length; i++) {
	    if (!cards[i].verify()) {
		tabPanel.select(i);
		showCard();
		return false;
	    }
	}
	return true;
    }

    protected void update() {
	for (int i = 0; i < cards.length; i++) {
	    cards[i].update();
	}
	params.writeParams(filename);
    }

    protected void actionCancel() {
	dispose();
    }

    protected void actionAccept() {
	if (!verify())
	    return;
	update();
	dispose();
    }
}
