package Freenet.node.gui;

import Freenet.Params;
import java.awt.*;

public class FProxySettings extends SettingsPanel {

    public FProxySettings(Params params, Help help) {
	super("FProxy");

	addHelp(help);
	addComponents(params, help);
    }

    public void addComponents(Params params, Help help) {
	add(new BooleanSetting(params, help, "Enable FProxy", "services.fproxy.class", true) {
	    final String fProxyClass = "Freenet.contrib.fproxy.HttpHandlerServlet";
	    public void update() {
		this.params.setParam(id, getState() ? fProxyClass : "");
	    }
	    protected boolean evaluateState(String id, boolean dfl) {
		String value = this.params.getParam(id, dfl ? fProxyClass : "");
		return value.trim().length() != 0;
	    }
	});
	add(new IntSetting(params, help, "FProxy port", "services.fproxy.port", 8080));
    }

    public void addHelp(Help help) {
	help.add("services.fproxy.class", "Enable/disable running FProxy automatically when starting the node.");
	help.add("services.fproxy.port", "Port number to use for FProxy.");
    }
}
