package Freenet.node.gui;


import Freenet.Params;
import Freenet.node.Node;
import java.awt.*;

public class InformSettings extends SettingsPanel {

    public InformSettings(Params params, Help help) {
	super("Inform");

	addHelp(help);
	addComponents(params, help);
    }

    public void addComponents(Params params, Help help) {
	add(new StringSetting(params, help, "Inform URL", "informURL", Node.defaultInformUrl));
	add(new BooleanSetting(params, help, "Read from inform", "informRead", Node.defaultInformRead));
	add(new BooleanSetting(params, help, "Write to inform", "informWrite", Node.defaultInformWrite));
	add(new IntSetting(params, help, "Inform write delay", "informDelay", Node.defaultInformDelay, "seconds"));
    }

    public void addHelp(Help help) {
	help.add("informURL", "The URL of a CGI script which will allow the server to learn about other servers in the Freenet and to inform other servers of its presence.");
	help.add("informRead", "Should we read some information about other nodes from the Inform URL?");
	help.add("informWrite", "Should we write our address to the inform URL so that others might find out about us more easily?");
	help.add("informDelay", "The deley between when the node is run and when it is added to the inform URL");
    }

}
