package Freenet.node.gui;

import Freenet.Params;
import java.awt.*;

public class IntSetting extends StringSetting {

    public IntSetting(Params params, Help help, String name, String id, int dfl) {
	this(params, help, name, id, dfl, "");
    }

    public IntSetting(Params params, Help help, String name, String id, int dfl, String units) {
	super(params, help, name, id, Integer.toString(dfl), units);
    }

    public IntSetting(Params params, Help help, String name, String id, long dfl, String units) {
	super(params, help, name, id, Long.toString(dfl), units);
    }

    protected void showVerify(boolean valid) {
	Color color = valid ? Color.black : Color.red;
	text.setForeground(Color.black);
	label.setForeground(Color.black);
    }

    protected boolean verifyValue(int value) {
	return true;
    }

    public boolean verify() {
	try {
	    int value = Integer.parseInt(text.getText());
	    if (verifyValue(value)) {
		showVerify(true);
		return true;
	    }
	}
	catch (NumberFormatException e) {
	}
	showVerify(false);
	return false;
    }

}
