package Freenet.node.gui;

import Freenet.Params;
import Freenet.Core;
import Freenet.node.Node;
import java.awt.*;

public class LoggingSettings extends SettingsPanel {

    public LoggingSettings(Params params, Help help) {
	super("Logging");

	addHelp(help);
	addComponents(params, help);
    }

    public void addComponents(Params params, Help help) {
	RadioSetting logLevel = new RadioSetting(params, help, "Logging level", "logging", "normal");
	logLevel.add("error");
	logLevel.add("normal");
	logLevel.add("minor");
	logLevel.add("debug");
	add(logLevel);
	add(new StringSetting(params, help, "Log file", "logFile", Node.defaultLogFile));
	add(new IntSetting(params, help, "Verbosity (1-5)", "verbosity", Node.defaultVerbosity) {
	    protected boolean verifyValue(int value) {
		return value >= 1 && value <= 5;
	    }
	});
    }

    public void addHelp(Help help) {
	help.add("logging", "Set what kind of events should be logged:\n Error:      Errors only\n Normal:     Report significant events\n Minor:      Report minor events\n Debug:  Report events only of relevance when debugging");
	help.add("logFile", "The name of the log file ('no' to log to standard out)");
	help.add("verbosity", "How verbose should the logging be.");
    }

}
