package Freenet.node.gui;

import Freenet.Params;
import Freenet.Core;
import java.awt.*;

public class NetworkSettings extends SettingsPanel {

    public NetworkSettings(Params params, Help help) {
	super("Network");

	addHelp(help);
	addComponents(params, help);
    }

    protected void addComponents(Params params, Help help) {
	add(new BooleanSetting(params, help, "Transient", "transient", Core.defaultTransience));
	add(new StringSetting(params, help, "Node address", "nodeAddress", "") {
	    public void update() {
		String s = text.getText();
		if (s.equals(""))
		    this.params.removeParam(id);
		else
		    this.params.setParam(id, text.getText());
	    }
	});
	add(new IntSetting(params, help, "Port number", "listenPort", Core.defaultListenPort));
    }

    protected void addHelp(Help help) {
	help.add("transient", "Transient nodes will not send their address to other nodes, and therefore will not get any requests for data (except if you activate the \"inform\" CGI service). Use this only if you are on a slow, non permanent connection. (Dialup users might want to use this option)");
	help.add("nodeAddress", "The address to use when advertising this node to  the network. If this unset, which is prefered, the node's address will be read from the socket, allowing the node to function seamlessly on multihomed machines (and even functioning a Freenet proxy over firewalls where necessary). However, people who have volatile IP addresses but constant DNS names (such as people using Dynamic DNS services) may wish to set this so their node can still be found after the ip changes.");
	help.add("listenPort", "The port to which the Freenet Server should listen for connections");
    }

}
