package Freenet.node.gui;

import Freenet.Params;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

public class RadioSetting extends Panel implements Setting, FocusListener {

    protected Params params;
    protected String name;
    protected String id;
    protected String dfl;
    protected Label label;
    protected Panel radioPanel;
    protected CheckboxGroup radioGroup;
    protected Vector radioButtons;
    protected Help help;

    public RadioSetting(Params params, Help help, String name, String id, String dfl) {
	super(new BorderLayout());

	this.params = params;
	this.help = help;
	this.name = name;
	this.id = id;
	this.dfl = dfl;

	label = new SettingLabel(name);
	add(label, BorderLayout.WEST);

	radioButtons = new Vector();
	radioPanel = new Panel();
	radioGroup = new CheckboxGroup();
	add(radioPanel, BorderLayout.CENTER);
    }

    protected CheckboxGroup createRadioPanel() {
	CheckboxGroup radioPanel = new CheckboxGroup();
	return radioPanel;
    }

    public void add(String name) {
	String value = params.getParam(id, dfl);
	Checkbox checkbox = new Checkbox(name, radioGroup, name.equalsIgnoreCase(value));
	checkbox.addFocusListener(this);
	radioPanel.add(checkbox);
	radioButtons.addElement(checkbox);
    }

    public void focusGained(FocusEvent e) {
	help.set(id);
    }

    public void focusLost(FocusEvent e) {
	help.clear(id);
    }

    public boolean verify() {
	return true;
    }

    public void update() {
	for (int i = 0; i < radioButtons.size(); i++) {
	    Checkbox radioButton = (Checkbox) radioButtons.elementAt(i); 
	    if (radioButton.getState()) {
		params.setParam(id, radioButton.getLabel());
	    }
	}
    }
}
