package Freenet.node.gui;

import Freenet.Params;
import Freenet.Core;
import Freenet.node.Node;
import java.awt.*;

public class RoutingSettings extends SettingsPanel {

    public RoutingSettings(Params params, Help help) {
	super("Routing");

	addHelp(help);
	addComponents(params, help);
    }

    public void addComponents(Params params, Help help) {
	add(new IntSetting(params, help, "Message store size", "messageStoreSize", Node.defaultMessageStoreSize, "messages"));
	add(new StringSetting(params, help, "Node file", "nodeFile", Node.defaultNodeFile));
	add(new IntSetting(params, help, "Band width limit", "bandWidthLimit", Node.defaultBandwidthLimit, "bps"));
	add(new IntSetting(params, help, "Max. connection threads", "maximumConnectionThreads", Core.defaultMaximumConnectionThreads));
	add(new IntSetting(params, help, "Max. hops to live", "maxHopsToLive", Node.defaultMaxHopsToLive));
    }

    public void addHelp(Help help) {
	help.add("messageStoreSize", "The number of outstanding message replies the node will wait for before it starts to \"forget\" them.");
	help.add("nodeFile", "The name of a file containing an initial set of nodes to connect to.");
	help.add("bandWidthLimit", "The maximum rate to transmit data.");
	help.add("maximumConnectionThreads", "Should we use thread-management?  If this number is define and non-zero, this specifies how many inbound connections can be active at once.");
	help.add("maxHopsToLive", "The number of hops to live to tolerate on Requests the node passes.  This does not directly effect your node, only the total load on the network, so there is no reason to change it.");
    }

}
