package Freenet.node.gui;

import Freenet.Params;

import java.awt.*;
import java.util.Vector;

public class SettingsPanel extends Panel {

    private ScrollPane scrollPane;
    private Container contentPane;
    private Component footer;
    private final Font titleFont = new Font("SanSerif", Font.PLAIN, 14);
    private Vector settings;

    public SettingsPanel(String name) {
	super(new BorderLayout());
	setName(name);
        footer = new Panel();
	settings = new Vector();

	addComponents();
    }

    public void addComponents() {
	Label title = new Label(getName());
	title.setForeground(Color.blue); 
	title.setFont(titleFont);
	super.add(title, BorderLayout.NORTH);

	contentPane = new Panel();
	contentPane.setLayout(new GridBagLayout());

	scrollPane = new ScrollPane();
	scrollPane.add(contentPane);
	super.add(scrollPane, BorderLayout.CENTER);
    }

    public Component add(Component c) {
	if (c instanceof Setting)
	    settings.addElement(c);

        contentPane.remove(footer);
	GridBagConstraints gbc = new GridBagConstraints();
	gbc.gridwidth = GridBagConstraints.REMAINDER;
	gbc.weightx = 1.0;
	gbc.weighty = 0.0;
	gbc.fill = GridBagConstraints.HORIZONTAL;

	contentPane.add(c, gbc);

	gbc = new GridBagConstraints();
	gbc.gridwidth = GridBagConstraints.REMAINDER;
	gbc.gridheight = GridBagConstraints.REMAINDER;
	gbc.weighty = 1.0;
        contentPane.add(footer, gbc);
	return c;
    }

    public boolean verify() {
	for (int i = 0; i < settings.size(); i++) {
	    Setting setting = (Setting) settings.elementAt(i);
	    if (!setting.verify())
		return false;
	}
	return true;
    }
 
    public void update() {
	for (int i = 0; i < settings.size(); i++) {
	    Setting setting = (Setting) settings.elementAt(i);
	    setting.update();
	}
    }

}
