package Freenet.node.gui;

import Freenet.Params;
import Freenet.Core;
import Freenet.node.Node;
import java.awt.*;

public class StoreSettings extends SettingsPanel {

    public StoreSettings(Params params, Help help) {
	super("Store");

	addHelp(help);
	addComponents(params, help);
    }

    public void addComponents(Params params, Help help) {
	add(new IntSetting(params, help, "Save to disk every", "checkpointInterval", Node.defaultCheckpointInterval, "seconds"));
	add(new IntSetting(params, help, "Max. disk usage", "diskCache", Node.defaultDiskCache, "bytes"));
	add(new IntSetting(params, help, "Max. no. of files", "dataStoreSize", Node.defaultDataStoreSize));
	add(new StringSetting(params, help, "Data path", "dataPath", Node.defaultDataPath));
	add(new StringSetting(params, help, "Data properties path", "dataPropertiesPath", Node.defaultDataPropertiesPath));
    }

    public void addHelp(Help help) {
	help.add("checkpointInterval", "How often to write the datastore to disk.");
	help.add("diskCache", "The maximum size of the datastore in bytes");
	help.add("dataStoreSize", "The maximum number of files stored in the datastore");
	help.add("dataPath", "Directory containing the datastore");
	help.add("dataPropertiesPath", "Directory containing the properties of files stored in the datastore");
    }

}
