package Freenet.node.gui;

import Freenet.Params;

import java.awt.*;
import java.awt.event.*;

public class StringSetting extends Panel implements Setting, TextListener, FocusListener {

    protected Params params;
    protected String name;
    protected String id;
    protected String dfl;
    protected TextComponent text;
    protected Label label;
    protected Help help;
    
    public StringSetting(Params params, Help help, String name, String id, String dfl) {
	this(params, help, name, id, dfl, "");
    }

    public StringSetting(Params params, Help help, String name, String id, String dfl, String units) {
	super(new BorderLayout());

	this.params = params;
	this.help = help;
	this.name = name;
	this.id = id;
	this.dfl = dfl;

	label = new SettingLabel(name);
	add(label, BorderLayout.WEST);

	text = createTextComponent();
	add(text, BorderLayout.CENTER);

	add(new Label(units), BorderLayout.EAST);
    }

    protected TextComponent createTextComponent() {
	TextField text = new TextField(params.getParam(id, dfl));
	text.addTextListener(this);
	text.addFocusListener(this);
	return text;
    }

    public void textValueChanged(TextEvent e) {
	verify();
    }

    public void focusGained(FocusEvent e) {
	help.set(id);
    }

    public void focusLost(FocusEvent e) {
	help.clear(id);
    }

    public boolean verify() {
	return true;
    }

    public void update() {
	params.setParam(id, text.getText());
    }
}
