package Freenet.node.gui;

import Freenet.Params;
import Freenet.Core;
import java.awt.*;

public class TimingSettings extends SettingsPanel {

    public TimingSettings(Params params, Help help) {
	super("Timing");

	addHelp(help);
	addComponents(params, help);
    }

    public void addComponents(Params params, Help help) {
	add(new IntSetting(params, help, "Tick time", "tickerTime", Core.defaultTickerTime, "ms"));
	add(new IntSetting(params, help, "Hop time expected", "hopTimeExpected", Core.defaultHopTimeExpected, "ms"));
	add(new IntSetting(params, help, "Hop time deviation", "hopTimeDeviation", Core.defaultHopTimeDeviation, "ms"));
	add(new IntSetting(params, help, "Authentication timeout", "authTimeout", Core.defaultAuthTimeout, "ms"));
	add(new IntSetting(params, help, "Connect timeout", "connectTimeout", Core.defaultConnectTimeout, "ms"));
//	add(new BooleanSetting(params, help, "Do handshake", "doHandshake", true));
	add(new IntSetting(params, help, "Handshake life", "handshakeLife", Core.defaultHandshakeLife, "ms"));
	add(new IntSetting(params, help, "Handshake timeout", "handshakeTimeout", Core.defaultHandshakeTimeout, "ms"));

    }

    public void addHelp(Help help) {
	help.add("tickerTime", "The number of milliseconds between ticks on the timer");
	help.add("hopTimeExpected", "The expected time, in milliseconds, that it takes a Freenet node to pass a message. These are used to calculate how long the node should wait before assuming that a passed message is lost.  These are mostly here for debugging reasons - changing them will NOT make requests come back faster for you.");
	help.add("hopTimeDeviation", "The expected standard deviation, in milliseconds, that it takes a Freenet node to pass a message. These are used to calculate how long the node should wait before assuming that a passed message is lost.  These are mostly here for debugging reasons - changing them will NOT make requests come back faster for you.");
	help.add("authTimeout", "How long to wait for authentication before giving up.");
	help.add("connectTimeout", "How long to wait to connect to a host before giving up.");
//	help.add("doHandshake", "Leave this as \"yes\" unless you are doing timeout debugging.");
	help.add("handshakeLife", "How long before a handshake expires.");
	help.add("handshakeTimeout", "How long before a handshake times out.");
    }

}
