package Freenet.scripts;

import java.util.Vector;
import java.net.ServerSocket;

/**
 * ServerPortSearch.java
 *
 * August 28, 2000
 *
 * Retrieve a free local port number that is >1024.  This port number
 * is not already reserved by another service (tested against an 
 * internal list of ports), and can be bound by the current process.
 * @author lmh (LeaveMeHigh@aol.com)
 */

class ServerPortSearch {

    /**
     * Maintain a list of returned validated ports.  This is
     * so we don't return identical port numbers if getFreePort() is
     * called multiple times.
     */
    private Vector triedPorts;
    
    /**
     * Initialize the ArrayList.
     */
    public ServerPortSearch() {
        triedPorts = new Vector();
    }        
    
    /**
     * Generate port numbers 5000-65535 until it passes all the
     * tests.  Cache the port number in the array.  Return
     * the free port number to the user.
     *
     * The method "dies" after 25 tries, in the assumption 
     * that something is fundamentally wrong with the user's
     * system (read: with the binding).  Returns the port = -1
     * in that situation.
     */
    public int getFreePort() {
        boolean isAcceptable;
        int tries;
        int port;
	tries = 25;
        do {
            port = 5000 + (int)(Math.random() * 60536);
            isAcceptable = !triedPorts.contains(new Integer(port)) &&
		isFreeService(port) && 
		canBind(port);

	} while (!isAcceptable && --tries != 0);
        
        if (tries == 0) {
            return -1;
	} else {
            triedPorts.addElement(new Integer(port));
            return port;
	}
    }

    /**
     * Tests if the given port number is already taken by a 
     * previous service.  This method isn't necessarily compact
     * bytecode size - arrays are created at runtime - but it 
     * works.  The port number list should be expanded, it 
     * doesn't cover a lot.  People may also like a string comment
     * added to show what port goes with what service.
     *
     * Return true if the port isn't used, false otherwise.
     */
    private boolean isFreeService(int port) {
        int [] usedPorts = 
            { 1025,  1058,  1059,  1234,  1248,  1347,  
              1348,  1349,  1350,  1351,  1352,  1524,  
              1525,  1525,  1527,  1529,  1600,  1650,  
              2000,  2001,  2002,  2004,  2005,  2006,  
              2007,  2008,  2009,  2010,  2011,  2012,  
              2013,  2014,  2015,  2016,  2017,  2018,  
              2019,  2020,  2021,  2022,  2023,  2024,  
              2025,  2026,  2027,  2028,  2030,  2032,  
              2033,  2034,  2035,  2038,  2040,  2041,  
              2042,  2043,  2044,  2045,  2046,  2049,  
              2401,  2784,  3049,  3997,  3998,  3999,  
              4672,  5000,  5001,  5002,  5145,  5236,  
              6111,  6558,  7000,  7001,  7002,  7003,  
              7004,  7005,  7006,  7007,  7008,  7009,  
              8000,  9000,  9535,  17007  // ...
            };

        for (int i = 0; i < usedPorts.length; i++) {
            if (usedPorts[i] == port)
                return false;
	}	
        return true;
    }

    /**
     * Try to bind to the given port.  Return true
     * if the bind test was successful, false otherwise.
     */
    private boolean canBind(int port) {
        ServerSocket ss;

        try {
            ss = new ServerSocket(port);
            ss.close();
	} catch (Exception e) {
            return false;
	}
        return true;
    }
}







