#! /bin/sh
#
# /etc/init.d/freenet: Control Freenet node
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
JARFILE=/usr/share/java/freenet.jar
DAEMON=/usr/bin/java
NAME=freenet
DESC="Freenet node"
PIDFILE=/var/lib/freenet/$NAME.pid
CLASSPATH=$JARFILE

export CLASSPATH

test -f $DAEMON || exit 0
test -f $JARFILE || exit 0

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon --start --background --quiet --chuid freenet --pidfile $PIDFILE \
		--make-pidfile --exec $DAEMON -- Freenet.node.Node -paramFile /etc/freenet/freenetrc
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	if test -f $PIDFILE; then start-stop-daemon --oknodo --stop --quiet --pidfile $PIDFILE; rm $PIDFILE; fi
	echo "$NAME."
	;;
  restart|force-reload)
	echo -n "Restarting $DESC: "
	if test -f $PIDFILE; then start-stop-daemon --oknodo --stop --quiet --pidfile $PIDFILE; rm $PIDFILE; fi
	sleep 1
	start-stop-daemon --start --background --quiet --chuid freenet --pidfile $PIDFILE \
		--make-pidfile --exec $DAEMON --  Freenet.node.Node -paramFile /etc/freenet/freenetrc
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
