#!/bin/sh
#
# install.sh - install Freenet
#


# display banner intro
cat <<-EOF

Freenet installation
	
You are about to install a beta quality release of Freenet.  This means
that we *know* there are many bugs in it but we need you to test Freenet to
let us know what they are.  Freenet is being updated daily so it is
recommended that you regularly download and install a new snapshot.  You
should not be surprised if Freenet doesn't compile, or doesn't run -- but
if this happens please email freenet-dev@lists.sourceforge.net to let the
development team know that there is a problem.

WARNING: This release of Freenet is a proof-of-concept to test scalability
and routing.  It does not (yet) provide any meaningful security!  Please do
not insert or request any material which would place you at risk if your
anonymity were compromised.  If you require strong anonymity, please wait
for the next release.  However, if you want to help us test and develop the
system, please carry on!  

This script will install the Freenet server and Java client.
EOF


# check that Freenet was built already
echo -n "checking for compiled Node.class... "
if test ! -f ../node/Node.class; then
    echo "no"
    echo "Please run the ./build.sh script first."
    echo ""
    exit 2
fi
echo "yes"


# check for java runtime
echo -n "checking for java runtime... "
javaloc=`which java`
if test $? = 0; then
    echo "$javaloc"
else
    echo "no"
    echo "Please download a Java Development Kit (try http://java.sun.com)"
    echo ""
    exit 2
fi


# check java version
echo -n "checking java version is greater than 1.1 ... "
version=`$javaloc -version 2>&1 | head -1`
echo "$version"
case "$version" in
  *1.[12345]*) ;;
  * )
	echo ""
	echo "Freenet requires java compatible with Sun's 1.1 API"
	echo -n "I can't tell if yours qualifies.  Continue anyway [y/N]? "
	read bsh
	if test "$bsh" != "y"; then
	    echo "Please download Java 1.2 or 1.3 (try http://java.sun.com)"
	    exit
	fi
	;;
esac
echo ""


# Only install "for real" if running as root.
case "`whoami`" in
	root|toor) PREFIX="/usr/local" ;;
	*)
	    PREFIX="$HOME"
	    echo "Make sure to specify a path where you have write permission."
	    ;;
esac

echo -n "Where do you want to install Freenet [$PREFIX/freenet]? "
read foo
if test -n "$foo"; then
    # if foo is a relative path, find absolute path
    if test `echo $foo | cut -c1` != "/"; then
        INSTALLDIR=`pwd`/"$foo"
    else
        INSTALLDIR="$foo"
    fi
else
    INSTALLDIR="$PREFIX/freenet"
fi

# get local executable path and check permissions
echo -n "Should I make symbolic links to the Freenet scripts in $PREFIX/bin [Y/n]? "
read foo
if test "$foo" != "n"; then
    BINDIR="$PREFIX/bin"
    if test ! -w "$BINDIR"; then
	echo "$BINDIR is not writable!"
	exit
    fi
else
    BINDIR=""
    echo "ok, $INSTALLDIR/bin must be in the PATH environment variable"
    echo "of all users who will run the Freenet server"
fi


# Copy class files
echo "Creating $INSTALLDIR and copying files..."
install -d -m 0755 $INSTALLDIR
install -m 0644 ../README $INSTALLDIR/README
install -m 0644 ../mime.types $INSTALLDIR/mime.types
install -m 0644 sample.freenetrc $INSTALLDIR/sample.freenetrc
cd ..
echo "Creating $INSTALLDIR/Freenet"
install -d -m 0755 $INSTALLDIR/Freenet
install -m 0644 *.class $INSTALLDIR/Freenet
for dir in scripts message support support/io servlet servlet/util crypt crypt/ciphers client client/events client/listeners node thread transport presentation keys contrib/fproxy contrib/fcp contrib/fproxy/mumail/mime contrib/fproxy/filter; do
    echo "Creating $INSTALLDIR/Freenet/$dir"
    install -d -m 0755 $INSTALLDIR/Freenet/$dir
    install -m 0644 $dir/*.class $INSTALLDIR/Freenet/$dir
done
install -m 0644 contrib/fproxy/gateway.html $INSTALLDIR/Freenet/contrib/fproxy

# create scripts
cd scripts
echo "Creating $INSTALLDIR/bin"
install -d -m 0755 $INSTALLDIR/bin
for script in freenet_config freenet_server freenet_insert freenet_request; do
	dest=$INSTALLDIR/bin/$script
	echo "Creating $dest executable"
	sed "s#@classpath@#$INSTALLDIR#g" $script.in > $script
	install -m 0755 $script $dest
	rm -f $script
done

# make symlinks
if test -n "$BINDIR"; then
    echo "Making symlinks in $BINDIR"
    for program in freenet_config freenet_server freenet_insert freenet_request; do
	if test -e "$BINDIR/$program" ; then
	    echo "  $BINDIR/$program alreay exists; skipping."
	else
	    ln -s $INSTALLDIR/bin/$program $BINDIR/
	fi
    done
fi


# done
cat <<-EOF

	Installation done.
	
	YOU MUST RUN 'freenet_config' before running your node for the first
	time!  The config file should be named '.freenetrc' and placed in the
	directory where you installed freenet.
	
	Afterwards, cd to the directory where you installed freenet and type
	'freenet_server [options]' to start the server, or
	'freenet_server -help' for usage information.  Check freenet.log
	for any error messages once the server is running.

	Type 'freenet_insert' or 'freenet_request' to get usage information for
	the client.

EOF



