#!/bin/sh
# makeDist.sh - build binary Freenet distributions

# locations
TMP=/tmp
RELATIVE_DISTDIR=freenet
DISTDIR=$TMP/$RELATIVE_DISTDIR
TARFILE=freenet.tgz
ZIPFILE=freenet.zip

# check that Freenet was built already
echo -n "Checking for compiled Node.class... "
if test ! -f ../node/Node.class; then
    echo "no"
    echo "Please run make first."
    echo ""
    exit
fi
echo "yes"

# check that FProxy was built already
echo -n "Checking for compiled ProxyServer.class... "
if test ! -f ../contrib/fproxy/ProxyServer.class; then
    echo "no"
    echo "Not including FProxy in build"
    echo ""
else
    echo "yes"
fi


# check for old distribution directory
if test -f $DISTDIR; then
    echo "Removing old temporary directory $DISTDIR"
    rm -rf $DISTDIR
fi
mkdir $DISTDIR
echo $FPROXY
# make jar
echo "Creating jar file $DISTDIR/Freenet.jar"
cd ../..
jar -cvmf Freenet/node.manifest $DISTDIR/freenet.jar Freenet/*.class \
  Freenet/client/*.class Freenet/crypt/*.class Freenet/message/*.class \
  Freenet/node/gui/*.class Freenet/client/listeners/*.class \
  Freenet/node/*.class Freenet/support/*.class Freenet/support/io/*.class \
  Freenet/thread/*.class Freenet/transport/*.class Freenet/keys/*.class \
  Freenet/presentation/*.class Freenet/crypt/ciphers/*.class \
  Freenet/client/events/*.class Freenet/scripts/*.class \
  Freenet/servlet/*.class Freenet/servlet/util/*.class \
  Freenet/contrib/fproxy/gateway.html \
  Freenet/contrib/fproxy/*.class Freenet/contrib/fproxy/mumail/mime/*.class \
  Freenet/contrib/fproxy/filter/*.class Freenet/client/rdf/*.class \
  Freenet/client/rdf/impl/*.class Freenet/client/rdf/util/*.class \
  Freenet/client/rdf/vocabulary/*.class Freenet/contrib/xmlrpc/*.class \
  Freenet/contrib/xmlrpc/lib/*.class Freenet/contrib/xmlrpc/xml/*.class \
  Freenet/contrib/xmlrpc/xml/sax/*.class Freenet/contrib/fcp/*.class
chmod 644 $DISTDIR/freenet.jar

# add rest of files
cd Freenet
echo "Adding scripts"
install -m 0644 README $DISTDIR/README
install -m 0644 COPYING $DISTDIR/COPYING
install -m 0644 mime.types $DISTDIR/mime.types
cd scripts
install -m 0644 sample.freenetrc $DISTDIR/sample.freenetrc
install -m 0755 freenet_config.jar.in $DISTDIR/freenet_config
install -m 0755 freenet_server.jar.in $DISTDIR/freenet_server
install -m 0755 freenet_request.jar.in $DISTDIR/freenet_request
install -m 0755 freenet_insert.jar.in $DISTDIR/freenet_insert

# make tar file
echo "Creating tar archive $TARFILE"
( cd /tmp; tar -cvf - freenet ) | gzip -8 > $TARFILE

# add DOS files
echo "Setting up DOS distribution"
rm -f $DISTDIR/freenet_config $DISTDIR/freenet_server \
		$DISTDIR/freenet_insert $DISTDIR/freenet_request \
		$DISTDIR/sample.freenetrc $DISTDIR/mime.types \
                $DISTDIR/README $DISTDIR/COPYING $DISTDIR/mime.types

sed 's/
$//' ../README | sed 's/$/
/' > README.crlf
install -m 0644 README.crlf $DISTDIR/README.txt
rm README.crlf
sed 's/
$//' ../COPYING | sed 's/$/
/' > COPYING.crlf
install -m 0644 COPYING.crlf $DISTDIR/COPYING.txt
rm COPYING.crlf
sed 's/
$//' ../mime.types | sed 's/$/
/' > mime.types.crlf
install -m 0644 mime.types.crlf $DISTDIR/mimetype.txt
rm mime.types.crlf
sed 's/
$//' sample.freenetrc | sed 's/$/
/' > sample.freenet.ini.crlf
install -m 0644 sample.freenet.ini.crlf $DISTDIR/sample.freenet.ini
rm sample.freenet.ini.crlf
sed 's/
$//' FLaunch.jar.ini | sed 's/$/
/' > FLaunch.jar.ini.crlf
install -m 0755 FLaunch.jar.ini.crlf $DISTDIR/FLaunch.ini
rm FLaunch.jar.ini.crlf

install -m 0755 fserve.exe $DISTDIR/fserve.exe
install -m 0755 fserve.exe $DISTDIR/finsert.exe
install -m 0755 fserve.exe $DISTDIR/frequest.exe
install -m 0755 fserve.exe $DISTDIR/cfgnode.exe
install -m 0755 fserve.exe $DISTDIR/fproxy.exe

# make zip file
echo "Creating zip archive $ZIPFILE"
( cd $TMP; zip -Dr - $RELATIVE_DISTDIR ) > $ZIPFILE

#copying jar file
echo "Copying local jar file"
cp $DISTDIR/freenet.jar .

# cleanup
echo "Removing temporary directory $DISTDIR"
rm -rf $DISTDIR
echo "done"
