package Freenet.search;

/**
 * An abstract class representing a fuzzy operator
 **/
public abstract class FuzzyOperator
{
    /**
     * The children, if any, of this operator.  Must be
     * initialised to the appropriate size of array
     * in the constructor.
     **/
    public FuzzyOperator[] children;

    /**
     * Returns the score of s under this operator
     * @param s The string which we are testing
     * @return The score as a value between 0 and 1 where
     *         1 is a perfect match, and 0 is no match
     **/
    public abstract float score(String s) throws FuzzyOperatorException;
    public abstract String toString();
}
