////////////////////////////////////////////////////////////////////////////
//	GENERATED FILE
//	INPUT FILE: src/ServletResponse.java
//	TAGS USED: SERVLET_2_2 INTL
//
//	DO NOT EDIT!
////////////////////////////////////////////////////////////////////////////

/*
 * ServletResponse.java -- Class used to store servlet response
 *
 * Copyright (c) 1998, 1999 by Free Software Foundation, Inc.
 * Written by Paul Siegmann (pauls@euronet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation, version 2. (see COPYING.LIB)
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA
 */

package Freenet.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;


/**
 * A servlet can use this class to pass information to the client.
 *
 * @version Servlet API 2.2
 * @since Servlet API 1.0
 * @author Paul Siegmann (pauls@euronet.nl)
 */
public interface ServletResponse
{
	/**
	 * Tells the client how many bytes to expect.
	 *
	 * @since Servlet API 1.0
	 *
	 * @param length the number of bytes in the reply
	 */
	void setContentLength(int length);
	
	/**
	 * Tells the client what mime type to expect
	 *
	 * @since Servlet API 1.0
	 *
	 * @param type the mime type of the content
	 */
	void setContentType(String type);


	/**
	 * Creates a ServletOutputStream for the servlet to write the data to.
	 * <code>setContentLength</code> and <code>setContentType</code> can
	 * only be called before anything is written to this stream.
	 * It is only possible to call <code>getWriter</code> or
	 * <code>getOutputStream</code> on a response, but not both.
	 *
	 * @since Servlet API 1.0
	 *
	 * @return ServletOutputStream to write binary data
	 * @exception IOException if a i/o exception occurs
	 * @exception IllegalStateException if <code>getWriter</code> was already
	 * called on this response
	 */
	ServletOutputStream getOutputStream() throws IOException;


	/**
	 * Creates a PrintWriter for the servlet to print text to.
	 * The contenttype must be set before calling this method.
	 * It is only possible to call <code>getWriter</code> or
	 * <code>getOutputStream</code> on a response, but not both.
	 *
	 * @since Servlet API 2.0
	 *
	 * @return the created PrintWriter
	 * @exception IOException if a i/o exception occurs
	 * @exception IllegalStateException if <code>getOutputStream</code> was
	 * already called on this response
	 * @exception java.io.UnsupportedEncodingException if no suitable character
	 * encoding can be used
	 */
	PrintWriter getWriter() throws IOException;



	/**
	 * Returns the characterset encoding in use by this Response
	 *
	 * @since Servlet API 2.0
	 * @return the characterset encoding
	 */
	String getCharacterEncoding();


	/**
	 * XXX
	 */
	void setBufferSize(int size);


	/**
	 * XXX
	 */
	int getBufferSize();


	/**
	 * XXX
	 */
	void reset();


	/**
	 * XXX
	 */
	boolean isCommitted();


	/**
	 * XXX
	 */
	void flushBuffer() throws IOException;


	/**
	 * XXX
	 */
	void setLocale(Locale locale);


	/**
	 * XXX
	 */
	Locale getLocale();
}
