////////////////////////////////////////////////////////////////////////////
//	GENERATED FILE
//	INPUT FILE: src/UnavailableException.java
//	TAGS USED: SERVLET_2_2 INTL
//
//	DO NOT EDIT!
////////////////////////////////////////////////////////////////////////////

/*
 * UnavailableException.java -- Exception indicating that this servlet is
 *                              unavailable
 *
 * Copyright (c) 1998, 1999 by Free Software Foundation, Inc.
 * Written by Paul Siegmann (pauls@euronet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation, version 2. (see COPYING.LIB)
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA
 */

package Freenet.servlet;

/**
 * This is a special kind of exception telling the server that this particular
 * servlet is currently not available.
 * It has two kinds of unavailability:
 * <DL>
 * <DT>Permanent unavailable
 * <DD>This servlet is now and forever in the future unavailable.
 * If another class in spite of this fact asks this exception for how long it 
 * is unavailable it returns a negative number of seconds.
 * (-1 as a matter of fact)
 * <DT>Temporary unavailable
 * The servlet is currently unavailable, but will be available within
 * a certain number of seconds.
 * A class can ask the exception for that number of seconds.
 * </DL>
 *
 * @version Servlet API 2.2
 * @since Servlet API 1.0
 */
public class UnavailableException
	extends ServletException 
{
	private Servlet	servlet;
	private int	seconds;


	/**
	 * Constructor for a permanent unavailable exception
	 *
	 * @since Servlet API 2.2
	 */
	public UnavailableException(String message) {
		super(message);
		seconds = -1;
	}


	/**
	 * Constructor for a temporary unavailable exception
	 *
	 * @since Servlet API 2.2
	 */
	public UnavailableException(String message, int seconds) {
		super(message);
		this.seconds = seconds;
	}

	/**
	 * Constructor for a permanent unavailable exception
	 *
	 * @deprecated
	 * @since Servlet API 1.0
	 */
	public UnavailableException(Servlet servlet, String message) {
		super(message);
		this.servlet = servlet;
		seconds = -1;
	}


	/**
	 * Constructor for a temporary unavailable exception
	 * @deprecated
	 *
	 * @since Servlet API 1.0
	 */
	public UnavailableException(int seconds, Servlet servlet, String message) {
		super(message);
		this.servlet = servlet;
		this.seconds = seconds;
	}


	/**
	 * Check whether the servlet is permanently unavailable
	 *
	 * @since Servlet API 1.0
	 *
	 * @return whether the servlet is permanently unavailable
	 */
	public boolean isPermanent() {
		return seconds < 0;
	}


	/**
	 * Gets the servlet that is unavailable
	 *
	 * @deprecated
	 * @since Servlet API 1.0
	 */
	public Servlet getServlet() {
		return servlet;
	}

	/**
	 * Gets the number of seconds the servlet is unavailable
	 *
	 * @since Servlet API 1.0
	 *
	 * @return the number of seconds. Negative if permanently unavailable
	 */
	public int getUnavailableSeconds() {
		return seconds;
	}
}
