package Freenet.sim;

import org.gamora.*;
import org.gamora.util.*;

public class FreenetSim extends GamoraPlugin implements ListenObject {

    public FreenetSim(CoreController cc, String args) {
	super(cc, args);
	desc.name="FreenetSim";
	desc.description=
	    "A Freenet simulation architecture\n"+
	    "---------------------------------\n"+
	    "Built on the GNU Adaptable Multiplatform Routing Architecture\n"+
	    "\nThis plugin released under the GNU General Public License\n"+
	    "Gamora is released under the Mozilla Public License\n"+
	    "Both are copyright (C) 2000 Scott G. Miller";
    }
    
    /*
      Beat time in milliseconds.  This is the SIMULATED but REAL time
      that virtual nodes see
    */
    protected int resolution=100; 
    /*
      How fast to accelerate the simulator.  0.1 means that that one
      second on the virtual freenet takes 0.1 seconds to elapse
    */
    protected double compression=1; // For now

    public void activate() {
	Clock c=new Clock(coreController, 
			  (int)(resolution*compression), false);
	onBus.addComponent(c);
	onBus.addController(this);
	
	coreController.objectActivate(c);
    }

    public Object receive(Object data, BusObject origin) {
	return null;
    }
}


