package Freenet.sim;

import org.gamora.*;
import org.gamora.util.*;

/**
 * Serves to isolate the node from the event system, so we can induce
 * things like latency and poor connections
 */
public class Isolator extends SimCore implements ListenObject {
    class Packet {
	Object data;
	BusObject origin;

	public Packet(Object data, BusObject origin) {
	    this.data=data;
	    this.origin=origin;
	}
    }

    protected FifoBuffer queue; // A queue
    protected int latency, resolution;
    protected double connectionProbability;
    protected ListenObject isolated;

    public Isolator(CoreController cc, ListenObject isolated, int resolution) {
	this(cc, resolution);
	isolate(isolated);
    }

    public Isolator(CoreController cc, int resolution) {
	super(cc);
	this.resolution=resolution;
	desc.name="Isolator:"+Integer.toHexString(hashCode());
	desc.description="Simulation isolator";
	queue=new FifoBuffer();
    }

    public void isolate(ListenObject b) {
	isolated=b;
    }

    public void setConnProb(double prob) {
	connectionProbability=prob;
    }

    public void setLatency(int ms) {
	latency=ms/resolution;
    }

    public Object receive(Object data, BusObject origin) {
	if (data instanceof ClockPulse) {
	    if (!queue.empty()) {
		Object first=queue.next();
		if (first instanceof Long) {
		    Long l=(Long)first;
		    long v=l.longValue();
		    v--;
		    if (v!=0)
			queue.insertElementAt(new Long(v), 0);
		} else {
		    Packet p=(Packet)first;
		    isolated.receive(p.data, p.origin);
		} 
	    }
	    return null;
	} else if (data instanceof Connection) {
	    double d=random.nextDouble();
	    if ((d-(int)d) > connectionProbability)
		return null;
	}

	queue.addElement(new Long(latency));
	queue.addElement(new Packet(data, origin));

	return null;
    }
}
