import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import org.gamora.CoreController;

public class Edge extends GraphComponent {
    public static final int SIZE=9;
    public Vertex[] connections;

    public Edge(CoreController cc, Vertex one, Vertex two) {
	super(cc);
	connections=new Vertex[] {one, two};
	location=one.location;
    }

    public void paint(Graphics g) {
	super.paint(g);
	g.drawLine(connections[0].location.x, connections[0].location.y,
		   connections[1].location.x, connections[1].location.y);
	Point mid=midpoint();
	g.drawOval(mid.x-(SIZE/2), mid.y-(SIZE/2), SIZE, SIZE);
    }

    public Point midpoint() {
	return new Point((connections[0].location.x+
			  connections[1].location.x)/2, 
			 (connections[0].location.y+
			  connections[1].location.y)/2);
    }

    public boolean contains(int x, int y) {
	Point mid=midpoint();
	return distance(x, y, mid.x, mid.y)<SIZE;
    }
    
    public boolean connects(Vertex v) {
	for (int i=0; i<connections.length; i++)
	    if (connections[i]==v) return true;
	return false;
    }
}
